/* QDEMO2.C - Child program for demonstrating Queue usage.
 * Copyright (c) 1988 PC Tech Journal and Ziff-Davis Publishing Co.
 * Written by Ted Mirecki
 */
#define INCL_DOS        /* include all DOS* function prototypes */
#include  <os2.h>
                        /* Q item type codes:                    */
#define I_NUM 0         /*    long int, not pointer              */
#define I_NAME 1        /*    ptr to named shared mem            */
#define I_OWN 2         /*    ptr to owner's memory (given)      */
#define I_DISJ 3        /*    ptr to disjoint memory (gettable)  */

char text1[] = "This message written into a named shared segment";
char text2[] = "This message written into owner's segment";
char text3[] = "This message written into disjoint address space";
char fmt[20];        /* Format string for progress messages */

SEL   SharedSeg;           /* selector for shared memory */
HQUEUE Qhan;               /* handle of queue       */
int   err;
PID   progid;              /* process ID of this program */

main(int argc, char **argv)
{
   LINFOSEG far *local;       /* ptr to Local Info seg */
   SEL   Gseg, Lseg;          /* selectors for info segs*/
   PID   owner;               /* process ID of Q owner */
   USHORT offs;               /* offset portion of far pointer */
   USHORT items;              /* count of items in Q */
   char far *outmsg;          /* pointer to Q message */
/******************************************************************
   INITIALIZE:  open the Q. 
 ******************************************************************/
   DosGetInfoSeg(&Gseg, &Lseg);   /* get info segments */
   local = MAKEP(Lseg, 0);
   progid = local->pidCurrent;
   sprintf(fmt, "Process %d: %%s\n", progid);   /* create format string */
   printf(fmt, "Child process started; Args: (Q, Memory)");
   if (argc < 3)  {
      printf(fmt, "Too few parameters");
      exit(1);
   } else {
      printf(fmt, argv[1]);
      printf(fmt, argv[2]);
   }
   err = DosOpenQueue(&owner, &Qhan, argv[1]);
   if (err) errmsg("Open Q", err);
   printf(fmt, "Press return to continue\n");
   fgetchar();
/******************************************************************
   WRITE Q ITEM IN NAMED MEMORY 
 ******************************************************************/
   err = DosGetShrSeg(argv[2], &SharedSeg);
   if (err) errmsg("Get Shared Memory", err);
   err = DosSubAlloc(SharedSeg, &offs, sizeof(text1));
   if (err) errmsg("Sub Alloc", err);
   outmsg = MAKEP(SharedSeg, offs);
   strcpy(outmsg, text1);
   err = DosWriteQueue(Qhan, I_NAME,      /* msg in named memory */
                       sizeof(text1),     /* msg length */
                       outmsg, 11);       /* address & priority  */
   if (err) errmsg("Write Q, Named memory", err); 
   printf(fmt, "Message in Named memory written to Q");
/******************************************************************
   WRITE Q ITEM IN MEMORY GIVEN TO OWNER
 ******************************************************************/
   err = DosAllocSeg(sizeof(text2), &SharedSeg, SEG_GIVEABLE);
   if (err) errmsg("Alloc Giveable", err);
   outmsg = MAKEP(SharedSeg, 0);
   strcpy(outmsg, text2);
   err = DosGiveSeg(SharedSeg, owner, &Gseg);
   if (err) errmsg("Give Seg", err);
   outmsg = MAKEP(Gseg, 0);
   err = DosWriteQueue(Qhan, I_OWN,       /* msg in given memory */
                       sizeof(text2),     /* msg length */
                       outmsg, 11);       /* address & priority  */
   if (err) errmsg("Write Q, Givable memory", err); 
   printf(fmt, "Message in Givable memory written to Q");
   DosFreeSeg(SharedSeg);
/******************************************************************
   WRITE Q ITEM IN MEMORY OWNER WILL GET
 ******************************************************************/
   err = DosAllocSeg(sizeof(text3), &SharedSeg, SEG_GETTABLE);
   if (err) errmsg("Alloc Gettable", err);
   outmsg = MAKEP(SharedSeg, 0);
   strcpy(outmsg, text3);
   err = DosWriteQueue(Qhan, I_DISJ,     /* msg in gettable memory */
                       sizeof(text3),    /* msg length */
                       outmsg, 11);      /* address, priority   */
   if (err) errmsg("Write Q, Gettable memory", err); 
   printf(fmt, "Message in Gettable memory written to Q");
/******************************************************************
   WRITE A NUMERIC VALUE
 ******************************************************************/
   err = DosWriteQueue(Qhan, I_NUM, /* msg is a number */
                       1234,        /* can be anything */
                       87654321L,   /* value in lieue of address */
                       11);         /* priority */
   if (err) errmsg("Write Q, Value", err);
   printf(fmt, "Value written to Q");
/******************************************************************
   CHECK THAT ITEM IN GETTABLE MEMORY HAS BEEN READ, THEN EXIT
 ******************************************************************/
   items = 1;
   while (items >= 1 && !err) {
      DosSleep(100L);
      err = DosQueryQueue(Qhan, &items);
   }
   printf(fmt, "Good-bye from child process");
}
/******************************************************************
   ERRMSG: Print error message, terminate process 
 ******************************************************************/
errmsg(char *func, USHORT err)
{
   printf("Process %d: Error %d in %s", progid, err, func);
   exit(1);
}
