/* QDEMO1.C - Parent program for demonstrating Queue usage. 
 * Copyright (c) 1988 PC Tech Journal and Ziff-Davis Publishing Co.
 * Written by Ted Mirecki
 */
#define INCL_DOS        /* include all DOS* function prototypes */
#include  <os2.h>
                        /* Q item type codes:                    */
#define I_NUM 0         /*    long int, not pointer              */
#define I_NAME 1        /*    ptr to named shared mem            */
#define I_OWN 2         /*    ptr to owner's memory (given)      */
#define I_DISJ 3        /*    ptr to disjoint memory (gettable)  */

char fmt[20];        /* Format string for progress messages */
char Pname[] = "QDEMO2.EXE";
char Qname[] = "\\QUEUES\\TEST00.Q";
char Mname[] = "\\SHAREMEM\\TEST00.SEG";
struct {
   char arg0[sizeof(Pname)];
   char arg1[sizeof(Qname)];
   char arg2[sizeof(Mname)];
} args;

SEL   NamedSeg;            /* selector of named shared memory */
HQUEUE Qhan;               /* handle of queue       */
int   err;
PID   progid;              /* process ID of this program */

main()
{
   LINFOSEG far *local;       /* ptr to Local Info seg */
   SEL   Gseg, Lseg;          /* selectors for info segs*/
   char far *outmsg;
   char  missing[65];         /* returned values from DosExecPgm */
   RESULTCODES results;
/******************************************************************
   INITIALIZE:  create the queue, allocate named shared memory
 ******************************************************************/
   DosGetInfoSeg(&Gseg, &Lseg);   /* get info segments */
   local = MAKEP(Lseg, 0);
   progid = local->pidCurrent;
   sprintf(fmt, "Process %d: %%s\n", progid);   /* create format string */
   printf(fmt, "Parent process started");
                              /* Create the Q */
   err = DosCreateQueue(&Qhan, 2, Qname);
   if (err) errmsg ("Create Q", err);     /* won't return */
   printf(fmt, "Queue created");
                              /* Allocate shared memory */
   #define NamedLen 8000
   err = DosAllocShrSeg(NamedLen, Mname, &NamedSeg);
   if (err) errmsg("Alloc Share", err);
   err = DosSubSet(NamedSeg, 1, NamedLen);
   if (err) errmsg("Sub Set", err);
   printf(fmt, "Named shared memory allocated");
/******************************************************************
  EXEC a child process, passing names of Q & memory.
  Continue reading until child passes termination value.
 ******************************************************************/
   strcpy(args.arg0, Pname);        /* build arg string */
   strcpy(args.arg1, Qname);
   args.arg1[sizeof(Qname)-1] = ' ';
   strcpy(args.arg2, Mname);
   err = DosExecPgm(missing,           /* buffer for missing name */ 
                    sizeof(missing),   /* its length */
                    EXEC_ASYNC,        /* don't wait for child */
                    &args, 0L,         /* args, same environment */
                    &results,          /* place for returned values */
                    Pname);            /* name of program */
   if (err) errmsg("Exec", err);
   while (Qread())  {
      printf(fmt, "Press return to continue\n");
      fgetchar();
   }
   DosCloseQueue(Qhan);
   printf(fmt, "Good-bye from parent process");
}
/******************************************************************
   QREAD(): Read from Q, with wait; determine message type, display
 ******************************************************************/
Qread()
{
   struct {
      PID    writer;          /* ID of writing process */
      int    type;            /* event ID = type of ptr to Q item: */
   } Qid;
   union {
      char far *msg;          /* pointer to received message */
      long     value;         /* value if item not a pointer */
   } Qitem;
   SEL   msgseg;              /* segment of message */
   USHORT msgoff;             /* offset of message  */
   char far *Qtext;           /* pointer to message text */
   int   msglen;              /* other element components */
   char  msgprio;
   err = DosReadQueue(Qhan, &Qid, 
                      &msglen, &Qitem, 
                      0,            /* read item at head of Q */
                      DCWW_WAIT,    /* wait if Q empty        */
                      &msgprio,     /* priority of item */
                      0L);          /* no semaphore ID  */
   if (err) errmsg("Read Q", err);
   printf(fmt, "Read Q item:");
   printf("    from Process %d\n", Qid.writer);
   printf("    pointer type %d\n", Qid.type);
   printf("    priority     %d\n", (int) msgprio);
   printf("    length       %d\n", msglen);
   switch (Qid.type)  {
      case I_NUM:  {
         printf("    Long value   %ld\n", Qitem.value);
         return (0);
      }
      case I_NAME:  {
         msgoff = OFFSETOF(Qitem.msg);
         Qtext = MAKEP(NamedSeg, msgoff);
         printf("    Message text:\n%s\n\n",  Qtext);
         err = DosSubFree(NamedSeg, msgoff, msglen);
         if (err) errmsg("Sub Free", err);
         break;
      }
      case I_OWN:  {
         printf("    Message text:\n%s\n\n",  Qitem.msg);
         DosFreeSeg(SELECTOROF(Qitem.msg) );
         break;
      }
      case I_DISJ:  {
         msgseg = SELECTOROF(Qitem.msg);
         err = DosGetSeg(msgseg);
         if (err) errmsg("Get Seg", err);
         printf("    Message text:\n%s\n\n",  Qitem.msg);
         DosFreeSeg(msgseg);
      }
   }                          /* end of switch */
   return (Qid.type);
}
/******************************************************************
   ERRMSG: Print error message, terminate process 
 ******************************************************************/
errmsg( char *func, USHORT err)
{
   printf("Process %d: Error %d in %s", progid, err, func);
   DosCloseQueue(Qhan);
   exit(1);
}
