#include <fstream.h>

#define Uses_TNSCollection
#define Uses_TObject
#include <tv.h>

class TPrintFile : public TObject
  {
  const char *_name;

  public:

  TPrintFile(const char *name);

  virtual ~TPrintFile();

  const char *name()
  {
  return (_name);
  }
  };

class TPrintQueue : public TNSCollection
  {
  enum
    {
    timeOut     = 0x01,
    ioError     = 0x08,
    selected    = 0x10,
    outOfPaper  = 0x20,
    acknowledge = 0x40,
    notBusy     = 0x80
    };

  enum
    {
    printChar, initPrinter, readStatus
    };

  int _port;		// Printer port number.
  ifstream f;		// Printer input file.
  char buffer[1024];	// Printer buffer.
  char *bufend;		// End of buffer.
  const char *bufptr;	// Current index into buffer.
  Boolean dialogOpen;	// True if error dialog box is open.

  public:

  static TPrintQueue printQueue;

  // Should be private.
  TPrintQueue(int port);

  void removeFile();

  void removeAll();

  Boolean cancel();

  void print();
  };

const int cmPrintFile   = 100;
