#include <bios.h>
#include <dos.h>
#include <string.h>

#define Uses_TApplication
#define Uses_TButton
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TLabel
#define Uses_TProgram
#define Uses_TRadioButtons
#define Uses_TSItem
#define Uses_TView
#include <tv.h>

#include "fileview.h"
#include "prfile.h"

int TFileViewer::filesOpen = 0;

void TFileViewer::handleEvent(TEvent& event)
{
TScroller::handleEvent(event);
if (event.what == evCommand)
  switch (event.message.command)
    {
    case cmPrintFile:
      printFile();
      clearEvent( event );
      break;
    }
}

TPrintFile::TPrintFile(const char *name) : TObject(),
_name(newStr(name))
{
}

TPrintFile::~TPrintFile()
{
delete _name;
}

TPrintQueue::TPrintQueue(int port) : TNSCollection(10, 5),
_port(port - 1), bufend(buffer), bufptr(buffer), dialogOpen(False)
{
}

void TPrintQueue::removeFile()
{
delete (TPrintFile*)at(0);
atRemove(0);
}

void TPrintQueue::removeAll()
{
while (count)
  removeFile();
}

Boolean TPrintQueue::cancel()
{
Boolean cancelled;

// Queue active if files remaining or buffer not empty.
if (count || bufptr != bufend)
  {
  TDialog *errdlg = new TDialog(TRect(0, 0, 29, 8),
				"Printer Warning");
  errdlg->options |= ofCentered;

  if (errdlg)
    {
    errdlg->insert(new TLabel(TRect(1, 1, 27, 2),
			      "Print queue is not empty.", 0));
    errdlg->insert(new TLabel(TRect(1, 2, 24, 3),
			      "Exiting will purge all", 0));
    errdlg->insert(new TLabel(TRect(1, 3, 13, 4),
			      "print jobs.", 0));

    errdlg->insert(new TButton(TRect(1, 5, 13, 7), "E~x~it",
			       cmOK, bfNormal));
    errdlg->insert(new TButton(TRect(15, 5, 27, 7), "Cancel",
			       cmCancel, bfDefault));

    if (lowMemory())
      {
      destroy(errdlg);
      cancelled = True;
      }
    else
      {
      // Alert user with error tone.
      sound(880);
      delay(100);
      sound(554);
      delay(100);
      nosound();

      switch (TProgram::deskTop->execView(errdlg))
	{
	case cmCancel:
	  cancelled = False;
	  break;

	case cmOK:
	  cancelled = True;
	  break;
	}

      destroy(errdlg);
      }
    }

  if (cancelled)
    removeAll();
  }
else
  cancelled = True;

return (cancelled);
}

void TPrintQueue::print()
{
if (bufptr != bufend)
  for (int i = 0, printOk = True; i < 100 && bufptr != bufend &&
       printOk; i++)
    {
    char *errmessage = 0;
    int printStat = biosprint(readStatus, 0, _port);

    if (printStat & outOfPaper)
      errmessage = "Out of paper.";
    else if (!(printStat & selected))
      errmessage = "Offline.";
    else if (printStat & (timeOut | ioError))
      errmessage = "I/O error.";
    else if (printStat & notBusy)
      // If the dialog box is open (user is being asked to reply to
      // an error), error has been cleared so clear dialog box.
      if (dialogOpen)
	{
	TEvent cancelEvent;

	cancelEvent.what = evCommand;
	cancelEvent.message.command = cmCancel;
	cancelEvent.message.infoPtr = 0;
	TProgram::application->putEvent(cancelEvent);

	// Instead of putEvent(), could also use:
	// message(TProgram::application, evCommand, cmCancel, 0);

	// Abort this invocation of the idle() routine.
	printOk = False;
	}
      else
	biosprint(printChar, *bufptr++, _port);

    if (errmessage)
      // If dialogOpen is True, this test will fail anyway.
      if (TProgram::application->TopView() == TProgram::application)
	{
	TDialog *errdlg = new TDialog(TRect(0, 0, 35, 5),
				      "Printer Error");
	errdlg->options |= ofCentered;

	if (errdlg)
	  {
	  errdlg->insert(new TLabel(TRect(1, 1, strlen(errmessage) +
					  2, 2), errmessage, 0));

	  errdlg->insert(new TRadioButtons(TRect(16, 1, 33, 4),
			 new TSItem("~R~etry",
			 new TSItem("~C~ancel file",
			 new TSItem("~P~urge queue", 0)))));

	  errdlg->insert(new TButton(TRect(1, 2, 15, 4), "O~K~",
				     cmOK, bfDefault));

	  if (lowMemory())
	    {
	    destroy(errdlg);
	    printOk = False;
	    }
	  else
	    {
	    ushort response = 0;
	    errdlg->setData(&response);

	    // Alert user with error tone.
	    sound(880);
	    delay(100);
	    sound(554);
	    delay(100);
	    nosound();

	    dialogOpen = True;
	    switch (TProgram::deskTop->execView(errdlg))
	      {
	      case cmCancel:
		break;

	      case cmOK:
		errdlg->getData(&response);
		switch (response)
		  {
		  case 0:
		    break;

		  case 2:
		    removeAll();

		  case 1:
		    f.close();
		    bufptr = bufend;
		    break;
		  }
		break;
	      }

	    destroy(errdlg);
	    dialogOpen = False;
	    }
	  }
	}
      else
	// Application is not modal view; wait until it is.
	printOk = False;
    }
else if (f.rdbuf()->is_open())
  {
  f.read(buffer, sizeof(buffer));
  bufend = buffer + f.gcount();
  bufptr = buffer;

  // If end of file, close file and add formfeed.
  if (bufend != buffer + sizeof(buffer))
    {
    f.close();
    *bufend++ = '\f';
    }
  }
else if (count)
  {
  f.open(((TPrintFile*)at(0))->name(), ios::in | ios::binary);
  removeFile();
  }
}

// Create print queue on port LPT1.
TPrintQueue TPrintQueue::printQueue(1);

void TFileViewer::printFile()
{
TPrintQueue::printQueue.insert(new TPrintFile(fileName));
}
