program Test_FInput;
{$X+}
uses App, Objects, Menus, Views, Drivers, Memory, Dialogs,
     FInput;

const
  cmOpenTestWindow = 1000;

type
  PMyApp = ^TMyApp;
  TMyApp = object(TApplication)
    procedure InitStatusLine; virtual;
    procedure InitMenuBar; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PMyTestWindow = ^TMyTestWindow;
  TMyTestWindow = object(TDialog)
    constructor Init(Bounds: TRect; WinTitle: string);
  end;

var
  MyApp: TMyApp;


constructor TMyTestWindow.Init(Bounds: TRect; WinTitle: string);
var
  R: TRect;
  Fld, Labl : PView;
begin
  TDialog.Init(Bounds, WinTitle);
  R.Assign(8,3,18,4);
  Fld := new(PFInputLine, Init(R, 8, DDateSet, DDate, 0));
  Insert(Fld);

    R.Assign(1,3,7,4);
    Labl := new(PLabel, Init(R, 'Date:', Fld));
    Insert(Labl);

  R.Assign(8,4,18,5);
  Fld := new(PFInputLine, Init(R, 8, DTimeSet, DTime, 0));
  Insert(Fld);

    R.Assign(1,4,7,5);
    Labl := new(PLabel, Init(R, 'Time:', Fld));
    Insert(Labl);

end;

procedure TMyApp.InitStatusLine;
var
  R : TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := new(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~F5~ Zoom', kbF5, cmZoom,
      NewStatusKey('~F6~ Next', kbF6, cmNext,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil)))),
    nil)
  ));
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := new(PMenuBar,Init(R, NewMenu(
    NewSubMenu('~T~est', hcNoContext, NewMenu(
      NewItem('~N~ew Window', '', kbNoKey, cmOpenTestWindow, hcNoContext,
      NewLine(
      NewItem('E~x~it','Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)))),nil))));
end;

procedure TMyApp.HandleEvent(var Event: TEvent);

  procedure OpenTestWindow;
  var
    R: TRect;
  begin
    R.Assign(30,10,54,18);
    DeskTop^.Insert(new(PMyTestWindow, Init(R, 'Test Window')));
  end;

begin
  TApplication.HandleEvent(Event);
  case Event.What of
    evCommand:
      begin
        case Event.Command of
          cmOpenTestWindow:    OpenTestWindow;
        else
          Exit;
        end;
        ClearEvent(Event);
      end;
  end;
end;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.
