PROGRAM WinCount;

USES
  WinCrt,
  WinDos;

VAR
  FileName : string;
  Start, Stop, TotalWords : longint;
  loop : byte;

FUNCTION FileExists (FileName : string) : boolean; far;
EXTERNAL 'WRDCOUNT' index 1;

PROCEDURE CountFile (FileName : string;
		     VAR Start, Stop, FinalCount : longint); far;
EXTERNAL 'WRDCOUNT' index 2;

BEGIN
	writeln ('WinCount 1.1, Windows Word Counter');
  writeln ('written by David Gerrold');
  writeln ('assembler code by David Neal Dubois');

  repeat
    writeln;
    FileName := ParamStr (1);
    if FileName > '' then
      if not FileExists (FileName) then begin
        writeln ('Sorry, I can''t find ''', FileName, '''.');
        FileName := '';
        end;

    if FileName = '' then begin
      writeln;
      writeln ('Please enter a valid file name.');
      write ('What file do you want to count?  ');
      readln (FileName);
      end;

{ upcase the FileName }
      for loop := 1 to length (FileName) do
        FileName [loop] := upcase (FileName [loop]);
  until
    FileExists (FileName) or (FileName = '');

  if FileName = '' then begin
    writeln;
    writeln ('Execution halted.');
    end
  else begin
    writeln;
    writeln ('Counting ', Filename);
    CountFile (FileName, Start, Stop, TotalWords);
    WriteLn;
    WriteLn ('Total number of words in file:  ', TotalWords:10);
  	WriteLn ('Total time: ', (Stop - Start)/1000:10:2, ' seconds.');
    end;
END.


