{$M 1024,0,0}
{$S-,R-}
program Int10;
  {-Simple program to illustrate ISRs using BASM}
uses Dos;

const
  VesaCallMade : Boolean = False;

var
  OldInt10Ptr : ^Pointer;

procedure Int10Handler; Near; Assembler;
asm
  jmp     @PastData
@OldInt10: dd 0
@PastData:
  cmp     ax,4F00h                 {is this a VESA present call}
  je      @VesaCall
@DoOldInt:
  jmp     dword ptr cs:@OldInt10   {call original int 10h handler}
@VesaCall:
  push    ds
  push    ax
  mov     ax,SEG @DATA             {set up TP's data segment}
  mov     ds,ax
  mov     VesaCallMade,1           {set our global boolean to True}
  pop     ax
  pop     ds
  jmp     @DoOldInt                {we're outahere}
end;

begin
  OldInt10Ptr := @Int10Handler;
  Inc(Word(OldInt10Ptr), 2);    {point to @OldInt10 in Int10Handler}
  GetIntVec($10, OldInt10Ptr^);    {store old int in code segment}
  SetIntVec($10, @Int10Handler);   {set int 10h to our ISR}
  SwapVectors;                     {undo TP's RTL ISRs}
  Keep(0);                         {go resident}
end.
