#include <stdio.h>

#define FALSE 0
#define TRUE !FALSE
#define RECORDSIZE 33

main()
{
	FILE    *inFile;
	char    name[26], sex, buf[RECORDSIZE + 1];
	int     age = 0, totAge = 0, totRecs = 0, length;
	double  gpa;
	float   totGPA = 0.0;
	int scanfix(char *, char *, ...);

	/* open the input data file */
	inFile = fopen("students.dat", "rt");
	if (inFile == NULL) {
		fprintf(stderr, "Cannot open input file\n");
		exit(1);
	}

	/* process each record */
	printf("Name                     Sex Age GPA\n\n");
	while (fgets(buf, RECORDSIZE + 1, inFile) != NULL) {
		if ((length = strlen(buf)) != RECORDSIZE) {
		   printf("Invalid record length (%d)\n", length);
		   exit(1);
		}
		scanfix(buf, "%-25s %1c %3d %3lf",
			name, &sex, &age, &gpa);
		printf("%-25s %c  %3d %3.1f\n",
			name, sex, age, gpa);

		totRecs++;
		totAge += age;
		totGPA += gpa;
	}

	fclose(inFile);
	printf("\nNumber of records = %3d\n", totRecs);
	printf("Average age       = %5.1f\n",
		(float) totAge / totRecs);
	printf("Average gpa       = %5.1f\n", totGPA / totRecs);
}
