/* NormalizeName() and helper functions. */
#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <string.h>

/*#define NEEDCLEANING*/   /* uncomment to compile CleanString */
/*#define GENTESTPROGRAM*/ /* uncomment to compile main */
#define HARDSPACE '\xff' /* a 'hard', i.e. non-breaking, space */

extern char *strupr(char *s); /* not prototyped in ANSI string.h */

/* Special characters to capitalize after: space,
   apostrophe, hyphen, and HARDSPACE. */
static char CapAfterCharList[] = " '-\xff";

/*  The list of nonbreaking prefixes. */
static char *NonBreakingPrefixList[] = {
     "St.","De","Del","Della","Di","De La",
     "Running",
     0
     };

#if defined(NEEDCLEANING)
/* -------------------- CleanString --------------------- */
static void CleanString(register char *s) {
  register char *t;
  for (t = s; *t; t++) /* convert control chars to spaces */
  if (iscntrl(*t)) *t = ' ';
  for (t = s; isspace(*t); t++); /* remove leading spaces */
  if (t != s) strcpy(s, t);
  /* remove trailing spaces */
  for (t = s + strlen(s) - 1; isspace(*t); t--);
  *(t + 1) = '\0';
  /* remove redundant internal spaces */
  if (*s) {  /* check that there's still something there */
    for (t = s; *t;) {
      while (*t && *t != ' ') {   /* find a blank */
        *s = *t;
        s++;
        t++;
      }
      *s = *t;             /* copy one blank */
      if (*t) {
        s++;
        t++;
        while (*t && *t == ' ') t++;
      } /* find next nonblank */
    }
  }
  return;
}
#endif

/* -------------------- DoCapAfterChar -------------------- */
static void DoCapAfterChar(char *s){
  register char *p, *t;
  /* check for NULL pointer or zero length string */
  if ((s == (char *) NULL) || !(*s)) return;
  for (p = CapAfterCharList; *p; p++) {
  /* move through the string, one char at a time */
    t = s;
    while (*(t + 1) != '\0') { /* terminate if '\0' */
      if (*t == *p)
        *(t + 1) = toupper(*(t + 1));
        t++;
    }
  }
  return;
}

/* -------------------- CapAfterStr -------------------- */
static void CapAfterStr(register char *s, char const * const pat) {
  int patlen;
  char *stop;

  /* check for NULL pointers and zero length strings */
  if ((s == (char *) NULL) || !(*s) || (pat == (char *) NULL) ||
  !(*pat))
     return;

  patlen = strlen(pat);     /* length of pattern */
  stop = s + strlen(s);     /* stop points to end of string ('\0') */
  while (1) {
    if ((s = strstr(s, pat)) == (char *) NULL)   /* look for match */
      return;         /* no more matches, so return */
  /* point to char after pattern and check for end of string */
    if ((s += patlen) >= stop)
      return;         /* don't cap past the end of the string */
    *s = toupper(*s);   /* capitalize char after matched pattern */
  }
}

/* -------------------- DoNonBreakingPrefixes ------------------- */
static void DoNonBreakingPrefixes(char *s) {
  int patlen;
  char *t, **listp;
  for (listp = NonBreakingPrefixList; *listp; listp++) {
    patlen = strlen(*listp);
    t = s;
    while (1) {
      if ((t = strstr(t, *listp)) == (char *) NULL)
        break;              /* no more matches */
      if (*(t + patlen) != ' ')
        break;              /* past end of string? */
      (*(t + patlen) = HARDSPACE);
      t += patlen;            /* move past match */
    }
  }
}

/* -------------------- RemoveHardSpaces --------------------- */
static void RemoveHardSpaces(register char *s) {
  while (s != (char *) NULL)
    if ((s = strchr(s, HARDSPACE)) != (char *) NULL)
      *s = ' ';
}

/* ------------------- LookForSuffixes ----------------------- */
static char *LookForSuffixes(char *s) {
  char *sptr;
  if ((sptr = strstr(s, " Jr")) != (char *) NULL) {
    if (*(sptr + 3) == '\0') /* needs a period */
      strcat(sptr, ".");
  }
  else if ((sptr = strstr(s, " Sr")) != (char *) NULL) {
    if (*(sptr + 3) == '\0') /* needs a period */
      strcat(sptr, ".");
  }
  else if ((sptr = strstr(s, " Iii")) != (char *) NULL)
    strupr(sptr);
  else if ((sptr = strstr(s, " Iv")) != (char *) NULL)
    strupr(sptr);
  else if ((sptr = strstr(s, " III")) != (char *) NULL)
  /* don't need to do anything */;
  else if ((sptr = strstr(s, " IV")) != (char *) NULL)
  /* don't need to do anything */;
  if (sptr != (char *) NULL)
    *sptr++ = '\0';     /* disconnect and point to suffix */
  return (sptr);
}

/* ------------------ NormalizeName ------------------- */
char *NormalizeName(char *s) {
  char *LastName, *Suffix, *TempString;
#if defined(NEEDCLEANING)
  CleanString(s);      /* clean up the string */
#endif

/* capitalization section */
  *s = toupper(*s);         /* always capitalize first char */
  DoCapAfterChar(s);
  CapAfterStr(s, "Mc");     /* always capitalize after Mc */

/* name rearrangement section */
  if (strchr(s, ',') == (char *) NULL) { /* put first name last */
/* allocate a temporary buffer to build new copy of string */
    if ((TempString = (char *) malloc(strlen(s) + 3)) !=
    (char *) NULL) {   /* connect any non-breaking prefixes */
       DoNonBreakingPrefixes(s);
       Suffix = LookForSuffixes(s);   /* disconnect suffixes */
       if ((LastName = strrchr(s, ' ')) != (char *) NULL) {
         strcpy(TempString, LastName + 1);  /* copy last name */
         strcat(TempString, ", ");          /* append comma */
         strncat(TempString, s, (LastName - s)); /* append rest */
         if (Suffix != (char *) NULL) {     /* reconnect suffixes */
           strcat(TempString, " ");
           strcat(TempString, Suffix);
         }
         RemoveHardSpaces(TempString);
         strcpy(s, TempString); /* copy back to original string */
       }
       free(TempString);         /* release temporary buffer */
    }
  }
  return (s);    /* return pointer to normalized string */
}

/* -------------------- Test Program ------------------- */
#if defined(GENTESTPROGRAM)
#define   NAMESIZE  80
void main(void) {
  char buf[NAMESIZE];
  fputs("Testing\n", stdout);
  while (fgets(buf, (NAMESIZE - 2), stdin) != NULL) {
    if (strchr(buf, '\n') != NULL)     /* remove newline */
      *(strchr(buf, '\n')) = '\0';
    fputs("-->", stdout);
    fputs(NormalizeName(buf), stdout);
    fputs("<--\n", stdout);
  }
  exit(0);
}
#endif
