/ * DDLST.C -- trace MS-DOS device driver chain
 * Author Jim Mischel.  */

#include <stdio.h>
#include <dos.h>

#define DEVTYPE 0x8000  /* mask for "Device Type" bit */

struct dd_hdr {     /* device driver header structure */
    struct dd_hdr far *nxt_dev;
    unsigned attr;
    void near *strat;
    void near *intr;
    char devname[8];
};

struct invars {       /* abbreviated invars structure */
    char skip1[8];
    char far * clock;	  /* pointer to CLOCK$ device */
    char far * con;	  /* pointer to CON device */
    char skip2[7];
    /* location of NUL device in DOS 2.x */
    struct dd_hdr far *nuldev2;
    char skip3[7];
    /* location of NUL device in DOS 3.0 and later */
    struct dd_hdr far *nuldev3;
};

void main (void) {
    struct dd_hdr far *dev;
    struct invars far *InvarsPtr;

    if (_osmajor < 2) {
	puts ("This program requires DOS V 2.0 or later");
	return;
    }

    /* get address of "invars" in ES:BX */
    _AX = 0x5200;
    geninterrupt (0x21);

    /* create pointer from ES:BX */
    InvarsPtr = MK_FP (_ES, _BX);

    /* initialize dev to point to NUL device */
    dev = (struct dd_hdr far *)
	   ((_osmajor >= 3) ? &InvarsPtr->nuldev3 :
			      &InvarsPtr->nuldev2);

    printf ("\ninvars at %Fp\n", InvarsPtr);
    printf ("CLOCK$ device at %Fp\n", InvarsPtr->clock);
    printf ("CON device at %Fp\n", InvarsPtr->con);
    puts("\n seg:ofs    name   typ  strat intr  attr");

    while (FP_OFF (dev) != 0xffff) {
	/* Print driver starting address */
	printf ("%Fp ", dev);

	/* Print device name and type */
	if (dev->attr & DEVTYPE) {
	    int x;		/* character device */
	    for (x = 0; x < 8; x++)
		putchar (dev->devname[x]);
	    printf (" CHR");
	}
	else			/* block device */
	    printf ("   %-5d BLK", dev->devname[0]);

	printf ("  %Np  %Np  %04X\n",
	        dev->strat, dev->intr, dev->attr);
	dev = dev->nxt_dev;	/* go for next device */
    }
}
