//-------------------------------------------------------------//
// File:  Fonttest.Cpp                                         //
// Desc:  Example program for HpFont/Flash font drawing code   //
//-------------------------------------------------------------//

#include "Fg.H"
#include "HpFont.Hpp"

extern int cdecl getch( void );

int main( )
{
     // init for graphics
     fg_init();

     // font_file is path to any valid HP Font File
     char *font_file = "AMER15.HP";

     // instantiate an instance of HpFont
     HpFont hpF( font_file );

     // something to draw
     char *greeting = "Hello, World";

     // draw it centered on the screen
     int x = ( fg.displaybox[FG_X1] + fg.displaybox[FG_X2]
               - hpF.strwidth( greeting ) ) / 2;
     int y = ( fg.displaybox[FG_Y1] + fg.displaybox[FG_Y2]
               - hpF.strheight( greeting ) ) / 2;

     // use color white
     int clr = fg.nsimulcolor - 1;

     // and draw string greeting
     hpF.drawstr( x, y, clr, greeting );

     // wait for a keypress
     getch();

     // terminate graphics mode
     fg_term();

     return 0;
}
