//-------------------------------------------------------------//
// File:   Font.Hpp                                            //
// Desc:   Definition for a generic Font Class                 //
// Author: Marv Luse, Autumn Hill Software                     //
//-------------------------------------------------------------//

#ifndef _FONT_HPP_
#define _FONT_HPP_

#include "Charactr.Hpp"

//........ Font Class

class Font
{
   public:

      int        fstatus;   // font status flag

   protected:

      int        cell_w;    // cell width in pixels
      int        cell_h;    // cell height in pixels
      int        ascent;    // ascent dist in pixels
      int        descent;   // descent dist in pixels
      int        pitch;     // default pitch in pixels
      int        ch_cnt;    // allocated Character cnt
      int        min_ch;    // min ASCII char code
      int        max_ch;    // max ASCII char code
      Character *ch;        // allocated Character array

   public:

      Font( );
      Font( int bgn_ch, int end_ch );
     ~Font( );
      int chmin( void ) { return min_ch; }
      int chmax( void ) { return max_ch; }
      int chcnt( void ) { return ch_cnt; }
      int  strwidth( char *str );
      int  strheight( char *str );
      void drawstr( int x, int y, int clr, char *str );
};

// constants for Font.fstatus

const int fntNOINIT  =  0;   // font never initialized
const int fntOKAY    =  1;   // font successfully instantiated
const int fntFAILED  = -1;   // some kind of failure

#endif
