//-------------------------------------------------------------//
//              Autumn Hill Software Incorporated              //
//          Copyright (c) 1991 -- All Rights Reserved          //
//-------------------------------------------------------------//
// File:   Font.Cpp                                            //
// Desc:   Methods for Font and Character Classes              //
// Vers:   1.0                                                 //
// Date:   Feb, 1991                                           //
//-------------------------------------------------------------//

#include "string.h"
#include "charactr.hpp"

//........ default constructor

Character::Character( ) : BitMask( )
{
     left_ofs = 0;
     top_ofs  = 0;
     delta_x  = 0;
}

//........ constructor using specified components

Character::Character( int w, int h, char *m) : BitMask( w, h, m )
{
     left_ofs = 0;
     top_ofs  = h;
     delta_x  = w;
}

//........ default destructor (implied call to ~BitMask())

Character::~Character( )
{
}

//........ draw character

void Character::drawch( int x, int y, int clr )
{
     draw( x+left_ofs, y+top_ofs, clr );
}
