//-------------------------------------------------------------//
// File:   BitMask.Cpp                                         //
// Desc:   Methods for the BitMask Class                       //
// Author: Marv Luse, Autumn Hill Software                     //
//-------------------------------------------------------------//

#include "fg.h"
#include "string.h"
#include "bitmask.hpp"

//........ default constructor

BitMask::BitMask( )
{
     width = height = rowbytes = 0;
     mask = 0;
}

//........ constructor using specified components

BitMask::BitMask( int w, int h, char *m )
{
     width    = w;
     height   = h;
     rowbytes = (w + 7) >> 3;
     if( (mask = new char[height*rowbytes]) != 0 )
        memcpy( mask, m, height*rowbytes );
}

//........ default destructor- needed to deallocate memory

BitMask::~BitMask( )
{
     if( mask )
        delete mask;
}

//........ function to draw a bitmask using Zortech FG library

void BitMask::draw( int x, int y, int clr )
{
     fg_box_t  mask_area;

     mask_area[FG_X1] = mask_area[FG_Y1] = 0;
     mask_area[FG_X2] = width -1;
     mask_area[FG_Y2] = height -1;

     fg_drawmatrix( clr, FG_MODE_SET, -1, FG_ROT0,
                    x, y, mask, mask_area, fg.displaybox );
}
