#pragma inline
#include <dos.h>

unsigned getpsp(void)           /* getpsp() returns segment */
{                               /* value of the current PSP */
  if (_osmajor < 3) _AH = 0x51; /* pointer.  Service 0x62   */
  else _AH = 0x62;              /* is used preferentially,  */
  asm int 21h                   /* but is unavailable to    */
  _AX = _BX;                    /* versions before DOS 3.0  */
}                                                        

void setpsp(unsigned segment)   /* setpsp() sets DOS's      */
{                               /* current PSP pointer to   */
  _AH = 0x50;                   /* segment value passed.    */
  _BX = segment;
  asm int 21h
}

int freemem(unsigned segment)   /* freemem() frees memory   */
{                               /* beginning at the segment */
  _AH = 0x49;                   /* value passed.  Current   */
  _ES = segment;                /* PSP pointer must aggree  */
  asm int 21h                   /* with owner of block to   */
  asm jc nok                    /* succeed.  Returns zero   */
  _AX = 0;                      /* if successful, DOS error */
nok:                            /* code if unsuccessful.    */
  ;
}
