/*
WHATITIS.C:	Determine type of PC for .BAT files

version:	11-02-89
compiler:	Microsoft QuickC version 2.x
uses:		dos.h, stdio.h, stdlib.h
module type:	.EXE (small model)

(C) Copyright 1989 Marty Franz
*/

/*
This module demonstrates functions that determine what type of
PC, XT, AT, PCjr, etc.	the machine is.
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define GET_CONFIG_INFO 0xc0		/* service */
#define MISC_INT 0x15			/* interrupt */

static union REGS inregs, outregs;
static struct SREGS segs;

struct model_entry
{
	char *name;
	int type;         // these were unsigned before
	int submodel;
}
;

#define N_MODELS 12

static struct model_entry model_table[N_MODELS] =
{
	"PC",               0xff, -1,
	"PC XT",            0xfe, -1,
	"PC XT",            0xfb, -1,
	"PCjr",             0xfd, -1,
	"AT",               0xfc, 0,
	"AT or Compaq 286", 0xfc, 1,
	"PC XT 286",        0xfc, 2,
	"PC Convertible",   0xf9, -1,
	"PS/2 Model 30",    0xfa, -1,
	"PS/2 Model 50",    0xfc, 4,
	"PS/2 Model 60",    0xfc, 5,
	"PS/2 Model 80",    0xf8, 0
}
;

char *unknown = "Unknown";

int pc_type(void)
{
	/*
	This function returns the type of PC we're running on.
	It looks at the ROM ID byte in the BIOS.  We use it to
	check against the work area returned by the get
	configuration call.
	*/

	unsigned id_byte;

	segread(&segs);
	movedata(0xf000, 0xfffe, segs.ds, &id_byte, 1);
	return id_byte & 0x00FF;
}

void features(unsigned b)
{
	/*
	Decode the feature byte returned from the get
	configuration service.
	*/

	puts((b & 0x02) ? "Micro channel" : "PC bus");
	puts((b & 0x04) ? "EBDA allocated" :
	  "No EBDA present");
	puts((b & 0x08) ? "External wait supported" :
	  "No external wait");
	puts((b & 0x10) ?
              "Keyboard intercept called by Int 0x09" : "");
	puts((b & 0x20) ? "Real-time clock present" :
	  "No real-time clock");
	puts((b & 0x40) ? "Second interrupt chip present" :
	  "Second interrupt chip not present");
	puts((b & 0x80) ? "DMA channel 3 used by hard disk BIOS" :
	  "DMA channel 3 not used by hard disk BIOS");
}

char *model_name(unsigned model, unsigned submodel)
{
	/*
	Return a string containing the model name given the model
	and submodel bytes.  A -1 in the structure means we don't
	care what the submodel is, the model byte is sufficient.
	*/

	int i;

	for (i = 0; i < N_MODELS; i++)
	{
		if (model_table[i].type == model &&
		  (model_table[i].submodel == -1 ||
		  model_table[i].submodel == submodel))
			return (model_table[i].name);
	}
	return unknown;

}

int pc_config(void)
{
	/*
	This function reads the configuration in the BIOS.  It
	then displays additional information about the PC.
	*/

	unsigned ds, model;
	char config[9];

	segread(&segs);
	ds = segs.ds;
	inregs.h.ah = GET_CONFIG_INFO;
	int86x(MISC_INT, &inregs, &outregs, &segs);
	movedata(segs.es, outregs.x.bx, ds, &config[0], 9);
	if (outregs.x.cflag)
	{
		if (outregs.h.ah == 0x80)
		{
		   printf("PC or PCjr detected\n");
		}
		else if (outregs.h.ah == 0x86)
		{
		   printf("XT BIOS 11/08/82 or AT BIOS 1/10/84\n");
		}
		else
		{
		   printf("Carry flag set, unknown type of PC\n");
		}
	}
	else /* carry not set, data area filled in */
	{
		model = (unsigned)(config[2] & 0x00ff);
		if (model == pc_type() )
		{
			printf("Model: %s\n",
			  model_name(model, config[3]));
			printf("Model type: %02x\n", model);
			printf("Submodel type: %d\n", config[3]);
			printf("BIOS revision level: %02d\n",
			  config[4]);
			printf("Feature byte: %02x  These are:\n",
			  config[5]);
			features(config[5]);
		}
		else
		{
			printf("Unknown type of PC\n");
		}
	}
}

int main(int argc, char *argv[])
{
	return pc_config();
}
