{Listing 3 - TILES unit interface section}

UNIT Tiles;

INTERFACE

USES GRAPH, DOS, PRINTER, Lists, ParDet, VGAExtra;

CONST
   UL = 1; UR = 2;
   LR = 3; LL = 4;

   EndOfPattern = '!';

   MaxPatternColors = 16;

TYPE
   Location = OBJECT(ListNode)
      X,Y : INTEGER;
      PROCEDURE Init;
      FUNCTION GetX : INTEGER;
      FUNCTION GetY : INTEGER;
   END;


   TilePtr = ^Tile;

   Tile = OBJECT(Location)
     Color : INTEGER;
     CONSTRUCTOR Init;
     PROCEDURE Draw; VIRTUAL;
     PROCEDURE Import(VAR PatFile : TEXT); VIRTUAL;
     PROCEDURE ChooseTileColor(ColorIndex : INTEGER);
   END;


   HalfTilePtr = ^HalfTile;

   HalfTile = OBJECT(Tile)
     Corner : 1..4;
     CONSTRUCTOR Init;
     PROCEDURE Draw; VIRTUAL;
     PROCEDURE Import(VAR PatFile : TEXT); VIRTUAL;
   END;


   PatternPtr = ^Pattern;

   Pattern = OBJECT(Location)
     Width,Height : INTEGER;
     Name : String;
     Tiles : TilePtr;
     CONSTRUCTOR Init(NameStr : String);
     PROCEDURE Draw;
     PROCEDURE Import(VAR PatternFile : TEXT);
   END;

VAR
   dX,dY,Scale : INTEGER;
   Trace : BOOLEAN;

PROCEDURE SetScale(NewScale : INTEGER);
PROCEDURE InitGraphics;
PROCEDURE DoneGraphics;
