; Input:  DS:BX = pointer to 256-byte character table, with
;              characters to be filtered designated by 0 and
;              other characters designated by themselves.
;         CX = # of characters in input buffer.
;         DS:SI = pointer to source buffer to filter from.
;         ES:DI = pointer to destination buffer to filter to.
;         The direction flag (DF) must be set to 0 (CLD).
; Output: DX = # of characters stored in output buffer.
FILTER:
     SUB  DX,DX     ;zero characters transferred counter
FILTER_LOOP:
     LODSB          ;get next character from source buffer
     XLAT           ;look it up in filter table
     AND  AL,AL     ;is it wanted?
     JZ   FILTER_NEXT    ;if not, go to next character
     STOSB          ;it's wanted, store it in output buffer
     INC  DX        ;count this character as usable
FILTER_NEXT:
     LOOP FILTER_LOOP
     RET
