Unit VidPoint;


INTERFACE

USES DOS;


{ Returns a pointer to the current hardware cursor position: }

FUNCTION CursorPointer : Pointer;


{ Returns a pointer to screen buffer address corresponding to X,Y: }

FUNCTION XYPointer(X,Y : Integer) : Pointer;


{ Writes count attribute bytes at hardware cursor position:}

PROCEDURE WriteAttribute(Attribute : Byte; Count : Integer);



IMPLEMENTATION


{ Returns a pointer to the current hardware cursor position: }


FUNCTION CursorPointer : Pointer;

VAR
  Regs   : Registers;
  Origin : Word;

BEGIN
  WITH Regs DO
    BEGIN
      Intr($11,Regs);  { Call Equipment Configuration Information }
      IF AX AND $0030 = $0030 THEN Origin := $B000 ELSE
        Origin := $B800;
      { Obtain the current cursor position from BIOS: }
      AH := $03; BH := 0;
      Intr($10,Regs);
      { Cursor row is now in DH; Column in DL; calculate offset of }
      {   cursor into video refresh buffer & make a pointer: }
      CursorPointer := Ptr(Origin,(DH * 160) + (DL * 2));
    END;
END;


{ Returns a pointer to screen buffer address corresponding to X,Y: }

FUNCTION XYPointer(X,Y : Integer) : Pointer;

VAR
  Regs   : Registers;
  Origin : Word;

BEGIN
  WITH Regs DO
    BEGIN
      Intr($11,Regs);  { Call Equipment Configuration Information }
      IF AX AND $0030 = $0030 THEN Origin := $B000 ELSE
        Origin := $B800;
      Dec(X); Dec(Y);  { Adjust X & Y to 0-origin }
      XYPointer := Ptr(Origin,(Y * 160) + (X * 2));
    END;
END;


{ Writes count attribute bytes at hardware cursor position:}

PROCEDURE WriteAttribute(Attribute : Byte; Count : Integer);

TYPE
  VidArray = ARRAY[0..4096] OF Byte;
  VidArrayPtr = ^VidArray;

VAR
  I : Integer;

BEGIN
  FOR I := 1 TO Count*2 DO
    IF Odd(I) THEN VidArrayPtr(CursorPointer)^[I] := Attribute;
END;


{ No initialization section }

END.
