/*
   SAMPLE.C - Written by Jake Richter, Panacea Inc.

   (Minor portions of this code appear in "Programming the 8514/A"
    from M&T Publishing)


   This code demonstrates the use of the IBM Adapter Interface.


   This program can be run by compiling it with the
   following line using MSC v5.1:

         CL -c SAMPLE.C
         LINK SAMPLE.C CALLAFI.OBJ


*/
/*---------------------------------------------------------------------------

   Include file section

   Include everything but the kitchen sink.

---------------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <malloc.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "ibmafi.h"     /* Used for AI info. Includes AFIDATA.H   */

/*---------------------------------------------------------------------------

   Global and Static definitions

---------------------------------------------------------------------------*/
static   HSCOL_DATA  hscol = {4, 0};


/*---------------------------------------------------------------------------

   Code

---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------

   FillRect(x, y, width, height, color)

   Fill a "width"x"height" rectangle with "color" at location "x,y".
   Use current drawing environment.

---------------------------------------------------------------------------*/
void  FillRect(x, y, width, height, color)
int   x, y, width, height, color;
{
                              /* Define the data structure      */
static   HRECT_DATA     rect = {8, 0, 0, 0, 0};

   hscol.index = color;       /* Set color passed value         */
   HSCOL(&hscol);

   rect.coord.x_coord = x;
   rect.coord.y_coord = y;
   rect.width = width;
   rect.height = height;      /* Set rectangle parameter block  */
   HRECT(&rect);              /* Fill the rectangle             */

   return;
}

/*---------------------------------------------------------------------------

   DrawLine(x1, y1, x2, y2, color)

   Draws a line from "x1,y1" to "x2,y2" in color.

---------------------------------------------------------------------------*/
void  DrawLine(x1, y1, x2, y2, color)
int   x1, y1, x2, y2, color;
{
                              /* Define the data structure     */
static   HLINE_DATA(2)  line = {8, 0, 0, 0, 0};

   hscol.index = color;          /* Set color passed value     */
   HSCOL(&hscol);

   line.coords[0].x_coord = x1;  /* Set the first coordinate   */
   line.coords[0].y_coord = y1;
   line.coords[1].x_coord = x2;
   line.coords[1].y_coord = y2;  /* Set the second coordinate  */

   HLINE(&line);                 /* Draw the line              */

   return;
}

/*---------------------------------------------------------------------------

   main(argc, argv)

   Where all the action happens. No passed parameters are used.

---------------------------------------------------------------------------*/
main(argc, argv)
int   argc;
char  **argv;
{
/*
   Allocate the data areas for the HQDPS, HOPEN, and HINIT
   commands. The non-zero values for initialization are
   the parameter block sizes. The structure definitions for
   HQDPS_DATA, HOPEN_DATA, HCLOSE_DATA, and HINIT_DATA are
   located in AFIDATA.H.
*/
static HQDPS_DATA       stateInfo = { 6, 0, 0, 0 };
static HOPEN_DATA       openData = { 3, 0, 0 };
static HINIT_DATA       stateData = { 2, 0 };
static HCLOSE_DATA      closeData = { 2, 1 };


   char     *stateBuffer; /* Pointer to task buffer */
   char far *statAddr;    /* Pointer to task buffer */
   int      i, j, x, y, count;
   int      deltaX, deltaY;


   if(!getafi())              /* Is AI loaded? */
      {
      printf("Error! No Adapter Interface Loaded.\n");
      exit(1);
      }

   /*
      Get the size of the state buffer. The C call "HQDPS" is
      actually a macro definition in IBMAFI.H. This applies
      to all the other AI calls as well.
   */
   HQDPS(&stateInfo);

   /*
      Use the state buffer size to dynamically allocate
      memory for the state buffer. The "+ 15" is necessary
      because HINIT requires the segment of the state buffer,
      and the buffer is assumed to start at offset 0 of that
      segment. By adding 15 to the size, we make sure that we
      have allocated enough space for the buffer even in the
      worst case situation in which the segment alignment is
      furthest off. Remember that segment alignment occurs at
      16 byte intervals where the linear address' least
      significant nibble is 0.
   */
   stateBuffer = (char *) malloc(stateInfo.size + 15);
   statAddr = (char far *) stateBuffer;

   /*
      Get the segment of the state buffer. Make sure to
      account for an allocation that is not segment boundary
      aligned.
   */
   stateData.segment = FP_SEG(statAddr) + ((FP_OFF(statAddr) + 15) >> 4);

   /*
      Initialize the parameters for the HOPEN command and
      make the call. The HOPEN command opens the AI for use.
      After the call has returned, check the return flags for
      an error condition.
   */
   openData.oflags = 0x00;
   openData.mode = 0;    /* Set the 1024x768 mode */
   HOPEN(&openData);
   if (openData.iflags)
      {
      printf("An error occurred while trying to open the AI!\n");
      exit(2);
      }

   /*
      No error occurred, so get the state information so we
      can start drawing.
   */
   HINIT(&stateData);

   /*
      Now it's time to draw some things. First, let's "bounce"
      filled rectangles around the display.
   */
   x = y = 0;        /* Start position */
   deltaX = 11;
   deltaY = 17;      /* Indicates rectangle velocity */
   while (!kbhit())  /* Exit when a key is pressed */
      {
      count = 5000;  /* 5000 rectangles */
      while (count--)
         {           /* Draw a 40x20 rectangle at x,y in diff. colors */
         FillRect(x, y, 40, 20, (count & 0x0F));
         x += deltaX;
         if (x < 0 || x > 983)
            {        /* If either edge goes too far, change direction */
            deltaX *= -1;
            x += deltaX;
            }
         y += deltaY;
         if (y < 0 || y > 747)
            {        /* If either edge goes too far, change direction */
            deltaY *= -1;
            y += deltaY;
            }
         }
   /*
      Now let's draw some line sweeps to create moire patterns, but
      use the last rectangle point as our "center".
   */
      for (i = 0; i < 1024; i += 2)
         {
         DrawLine(x, y, i, 0, i & 0x0F);
         DrawLine(x, y, 1023 - i, 767, i & 0x0F);
         }
      for (i = 0; i < 768; i += 2)
         {
         DrawLine(x, y, 0, i, i & 0x0F);
         DrawLine(x, y, 1023, 767 - i, i & 0x0F);
         }
      }              /* Do the whole thing over again */

   if (!getch())     /* If function key, get second code */
      getch();

   /*
      Now that we are done drawing, it's time to clean up
      after ourselves. This includes closing the AI and
      deallocating the state buffer.
   */
   HCLOSE(&closeData);
   free(stateBuffer);

   return(0);        /* No errors to report */
}

