{
 
                                                                          
         TITLE :      DGREBOOT.TPU                                        
       PURPOSE :      Reboot functions.  USE WITH EXTREME CARE.           
        AUTHOR :      David Gerrold, CompuServe ID:  70307,544            
  ______________________________________________________________________  
                                                                          
    Written in Turbo Pascal, Version 5.5,                                 
    with routines from TurboPower, Object Professional.                   
                                                                          
    Turbo Pascal is a product of Borland International.                   
    Object Professional is a product of TurboPower Software.              
  ______________________________________________________________________  
                                                                          
    This is not public domain software.                                   
    This software is copyright 1990, by David Gerrold.                    
    Permission is hereby granted for personal use.                        
                                                                          
         The Brass Cannon Corporation                                     
         9420 Reseda Blvd., #804                                          
         Northridge, CA  91324-2932.                                      
                                                                          
 
                                                                            }
{ Compiler Directives ===================================================== }

{$A-}    {Switch word alignment off, necessary for cloning}
{$R-}    {Range checking off}
{$B-}    {Boolean complete evaluation off}
{$S-}    {Stack checking off}
{$I-}    {I/O checking off}
{$N+,E+} {Simulate numeric coprocessor}
{$M 16384,0,327680} {stack and heap}
{$V-}    {Variable range checking off}

{ Name ==================================================================== }

UNIT DgReboot;
{
  The purpose of DgReboot is to provide routines for handling rebooting
  the system from within a program.
}

{ Interface =============================================================== }

INTERFACE

USES

{ Turbo Pascal 5.5 Unit }
  Dos;

{ Declarations ============================================================ }
{ Functions and Procedures ================================================ }
{
  USE WITH EXTREME CARE!
}
PROCEDURE WarmBoot;
{ like pressing Ctrl-Alt-Delete }

PROCEDURE ColdBoot;
{ like hitting the Big Red Switch }

PROCEDURE DisableReboot;
{ no more Ctrl-Alt-Delete }

PROCEDURE EnableReboot;
{ reinstalls Ctrl-Alt-Delete }

{ Implementation ========================================================== }

IMPLEMENTATION

{ ========================================================================= }
{ Disable/Enable declarations --------------------------------------------- }

CONST
  D_Key   = 83;                                  { delete key scancode }

VAR
  Kbd_Vec : Pointer;

{ ========================================================================= }
{ WarmBoot ================================================================ }
{
  WarmBoot and ColdBoot, written by Carley Philips of Borland International.
  Downloaded from CompuServe, BPROGA forum.
}

PROCEDURE WarmBoot;
{ Warm boot.  Same as Ctrl-Alt-Del }

BEGIN
Inline(                    {Assembly by Inline 04/04/88 21:41}
  $B8/$40/$00/             {mov ax,$40         ;BIOS data segment}
  $8E/$D8/                 {mov ds,ax          ;mov to DS}
  $C7/$06/$72/$00/$34/$12/ {mov wo [$72],$1234 ;set keyboard reset flag}
  $EA/$00/$00/$FF/$FF);    {jmp $FFFF:0000     ;go to BIOS reset}
END;

{ ColdBoot ================================================================ }

PROCEDURE ColdBoot;
{ Cold boot.  Same as reset button except hardware is not reset }

BEGIN
Inline(                    {Assembly by Inline 04/04/88 21:41}
  $B8/$40/$00/             {mov ax,$40         ;BIOS data segment}
  $8E/$D8/                 {mov ds,ax          ;mov to DS}
  $C7/$06/$72/$00/$00/$00/ {mov wo [$72],$0000 ;say not keyboard reset}
  $EA/$00/$00/$FF/$FF);    {jmp $FFFF:0000     ;go to BIOS reset}
END;

{ PROCEDURE Int9_ISR ====================================================== }

{
  Giving credit where credit is due:

  This inline code is lifted directly from Neil Rubenking's article
  on page 8 of the Jan/Feb 88 issue of Turbo Technix.

  It is also available on CompuServe, Borland's Turbo Pascal Forum,
  BPROGA, as part of a file called KEYINT.ARC;  KEYINT.ARC demonstrates
  a number of things that can be done by replacing the standard keyboard
  interrupt handler.  It can be found in the Turbo Pascal 4.x library.
}
PROCEDURE INT9_ISR (_Flags, _CS, _IP, _AX, _BX, _CX, _DX,
                            _SI, _DI, _DS, _ES, _BP:word);
INTERRUPT;
  (* ======================================== *)
  (* This routine suppresses the <Del> key.   *)
  (* If it detects either a "make" or a       *)
  (* "break" from the <Del> key, it simply    *)
  (* resets the keyboard.  Without <Del>      *)
  (* there's no way to enter <Ctrl><Alt><Del> *)
  (* so you can't reboot.                     *)
  (* ======================================== *)

BEGIN
  INLINE(
  $FB/              {STI            ;Allow interrupts}
  $9C/              {PUSHF          ;Save the flags}
  $E4/$60/          {IN   AL,$60    ;READ the keyboard port}
  $24/$7F/          {AND  AL,$7F    ;Mask off "break bit"}
  $3C/<D_KEY/       {CMP  AL,<D_KEY ;Is it a "Del" key?}
  $74/$18/          {JZ   GetOut    ;If so, throw it away}
  (* ============================ *)
  (* CHAIN to the regular INT 9   *)
  (* ============================ *)
  $9D/              {POPF         ;Restore the flags}
  $A1/>KBD_VEC+2/   {MOV  AX,[>KBD_VEC+2] ;Old vector seg to AX}
  $8B/$1E/>KBD_VEC/ {MOV  BX,[>KBD_VEC]   ;Old vector ofs to BX}
  $87/$5E/$0E/      {XCHG BX,[BP+$0E] ;Swap ofs w/ return address}
  $87/$46/$10/      {XCHG AX,[BP+$10] ;Swap seg w/ return address}
  $89/$EC/          {MOV  SP,BP ;UNDO procedure's entry code}
  $5D/              {POP  BP}
  $07/              {POP  ES}
  $1F/              {POP  DS}
  $5F/              {POP  DI}
  $5E/              {POP  SI}
  $5A/              {POP  DX}
  $59/              {POP  CX}
  $CB/              {RETF ;in effect, JMP to old vector}
{GetOut:}
  $E4/$61/          {IN   AL,$61  ;Read Kbd controller port}
  $88/$C4/          {MOV  AH,AL}
  $0C/$80/          {OR   AL,$80  ;Set the "reset" bit and}
  $E6/$61/          {OUT  $61,AL  ;  send it back to control}
  $86/$C4/          {XCHG AH,AL   ;Get back control value}
  $E6/$61/          {OUT  $61,AL  ;  and send it too}
  $9D/              {POPF         ;Restore the flags}
  $FA/              {CLI          ;No interrupts }
  $B0/$20/          {MOV  AL,+$20 ;Send an EOI to the}
  $E6/$20);         {OUT  $20,AL  ;  interrupt controller }
END;

{ DisableReboot =========================================================== }

PROCEDURE DisableReboot;
{ shell for interrupt handler, disables Ctrl-Alt-Delete }

BEGIN
  SetIntVec (9, @INT9_ISR);                      { install new vector }
END;

{ EnableReboot ============================================================ }

PROCEDURE EnableReboot;
{ shell for interrupt handler, re-enables Ctrl-Alt-Delete }

BEGIN
  SetIntVec (9, Kbd_vec);                        { restore OLD INT9 }
END;

{ ========================================================================= }
{ Initialization Variables ================================================ }

VAR
  ExitSave     : pointer;                        { for ExitProc }

{ ExitUnit ================================================================ }

{$F+} PROCEDURE ExitUnit; {$F-}

BEGIN
  ExitProc := ExitSave;                          { reset original address }
  EnableReboot;                                  { in case it's disabled }
END;

{ Initialization ========================================================== }

BEGIN
  ExitSave := ExitProc;                          { save old exit address }
  ExitProc := @ExitUnit;                         { get new exit address }

{
  If the user wants to disable the reboot, he'll need to replace the
  interrupt 9 vector;  to make sure that the original vector can be
  reinstalled, so that rebooting can be re-enabled, its address will
  be automatically saved in Kbd_Vec.
}
  GetIntVec (9, Kbd_Vec);                        { save old INT9 vector }
END.

{ ========================================================================= }
{ DgReboot History ======================================================== }

VERSION HISTORY:
  9005.05
    Totally restructured for consistency with Object Professional.

{ DgReboot Needs ========================================================== }

NEED TO ADD:
  Nothing right now.

{ Bug Reports ============================================================= }

BUGS:
  Would you believe that these are actually features?

  DisableReboot will not work with Sidekick installed.  Sidekick replaces
  the standard interrupt 9 vector with its own and is very resistant to
  any other program grabbing interrupt 9.  Therefore, while Sidekick is
  active, the user will be able to ctrl-alt-delete reboot out of a locked
  system.

  Do not use the DOS print command for background printing if you intend
  to blank the screen or lock the system.  The argument over which routine
  is entitled to use interrupt 9 will produce a fatal crash.  Plan on using
  the big red switch.

  If you don't use Sidekick, and you don't use the DOS print command, you
  should have no problem.  If you use either of these regularly, don't be
  casual about using the lock program routines or anything else which uses
  DisableReboot.

{ ========================================================================= }
{ ========================================================================= }

