/****************************************************************************

                                   PMCARD

               Copyright (c) 1990 Ziff Communications Company
                         Jeff Prosise * PC Magazine

PMCARD allows you to store names, addresses, and phone numbers using
a Rolodex metaphor.  On PCs with modems attached, it will also dial
the phone.  PMCARD requires OS/2 version 1.2 or later.

Source Files:  PMCARD          Make file
               PMCARD.DEF      Module definition file
               PMCARD.H        C header file
               PMCARD.C        C source file
               PMCARD.RC       Resource script file

Binary Files:  PMCARD.ICO      Icon file
               PMCARD.RES      Compiled resource file
               PMCARD.OBJ      Compiled source file

Executable:    PMCARD.EXE

Note:  PMCARD was developed using Microsoft C 5.1. Compiling it with
       C 5.1 requires the use of preprocessor C1L.EXE rather than C1.EXE.
       To compile it with C 6.0, use a /B1 switch.

****************************************************************************/

#define INCL_WIN
#define INCL_GPILCIDS
#define INCL_GPICONTROL
#define INCL_DOSDEVICES

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "pmcard.h"

MRESULT EXPENTRY ClientWndProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY AboutDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY SearchDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY SaveAsDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY OpenDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY ConfigDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY StatusDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY GotoDlgProc (HWND, USHORT, MPARAM, MPARAM);
MRESULT EXPENTRY DialDlgProc (HWND, USHORT, MPARAM, MPARAM);

VOID	UpdateMLE (void);
VOID	ShowCardNo (HPS);
USHORT	ReadFile (CHAR *);
USHORT	SaveFile (CHAR *);
USHORT	SaveBeforeExit (CHAR *);
VOID	PackBuffer (void);
USHORT	ProcessCard (HWND);
USHORT	DialPhone (CHAR *);
USHORT	BuildPhoneList (CHAR *);
VOID	CountDigits (CHAR far *, USHORT *, USHORT *);
VOID	CopyToList (USHORT, CHAR *, CHAR far *);
USHORT	FindPrevCard (void);
USHORT	FindNextCard (void);
USHORT	CheckCard (USHORT);
VOID 	FillDriveListBox (HWND, USHORT);
VOID 	FillDirListBox (HWND, USHORT);
VOID 	FillFileListBox (HWND, USHORT);
USHORT 	MakePath (CHAR *, USHORT);
USHORT	MakeQFN (CHAR *, CHAR *, USHORT);
VOID	ExtractFileName (CHAR *, CHAR *);

HAB		hab;
HWND	hwndClient, hwndMLE, hwndButton[4];
SHORT	cxChar, cyChar;
SHORT	CardCount = 1, CardNo = 0;
USHORT	usTopOffset;
USHORT	usCardLength[1000] = { 0x00 };
USHORT	usCardOffset[1000] = { 0x00 };
USHORT	usSelector1, usPhoneCount;
USHORT	usDeletedTextLength;
CHAR	far *chBufferPtr;
CHAR	szSearchText[41] = "";
CHAR	szCurrentFile[512] = "";
CHAR	chDeleteBuffer[1024], szTextBuffer[640];
CHAR	szPhoneNumber[17], szPhoneList[200];
BOOL	fEditing = FALSE, fCardInBuffer = FALSE, fCaseSensitive = FALSE;

CHAR	szAppName[] = "PMCARD";
CHAR	szKeyName1[] = "Settings";
CHAR	szKeyName2[] = "DialCmd";
CHAR	szKeyName3[] = "HangUpCmd";
CHAR	szKeyName4[] = "DefDataFile";
CHAR	szKeyName5[] = "DialPrefix";

CHAR 	szDialCmd[17];						// Modem dial command
CHAR 	szHangUpCmd[17];					// Modem hangup command
CHAR	szDefDataFile[129];					// Default data file
CHAR	szDialPrefix[7];					// Dial prefix

struct	CommParms {
	SHORT	BaudRate;						// Baud Rate (1200)
	SHORT	COMPort;						// COM port (1)
	SHORT	Parity;							// Parity setting (None)
	SHORT	DataBits;						// Number of data bits (8)
	SHORT	StopBits;						// Number of stop bits (1)
} GblParms = { 1, 0, 0, 1, 0 };

CHAR	Signature[] = { 0xBC, 0x9E, 0x8D, 0x9B, 0xB9, 0x96, 0x93, 0x9A };

CHAR	szErrMsg1[] = " was not found or could not be opened";
CHAR	szErrMsg2[] = "There's not enough memory to run PMCARD";
CHAR	szErrMsg3[] = "You've reached PMCARD's limit of 999 cards";
CHAR	szErrMsg4[] = " not found";
CHAR	szErrMsg6[] = " was not created by PMCARD";
CHAR	szErrMsg7[] = "There's not enough space on the disk to store the file";
CHAR	szErrMsg8[] = " could not be saved.  Check the path and filename for validity.";
CHAR	szErrMsg9[] = "There's not enough space to store the changes.  Delete some text and try again.";
CHAR	szErrMsg10[] = "You must first position the cursor where you want the text to be pasted";
CHAR	szErrMsg11[] = "There's not enough space to add this card";
CHAR	szErrMsg12[] = " doesn't exist or is in use by another process";
CHAR	szErrMsg13[] = "Your modem is not ready";
CHAR	szErrMsg14[] = "Your modem will not accept commands";
CHAR	szErrMsg15[] = "The selected text exceeds PMCARD's internal buffer length of 64 characters";

CHAR	szMsg1[] = "Save the current card stack?";
CHAR	szMsg2[] = "Pick up the handset and press OK";

/*---------------------------------------------------------------------------
	Function main
---------------------------------------------------------------------------*/

int main (int argc, char *argv[])
{
	static ULONG flFrameFlags = FCF_TITLEBAR		| FCF_SYSMENU	|
						        FCF_BORDER			| FCF_MINBUTTON	|
						        FCF_SHELLPOSITION	| FCF_TASKLIST	|
						        FCF_MENU			| FCF_ICON		|
								FCF_ACCELTABLE		;

	HMQ				hmq;
	HWND			hwndFrame;
	QMSG			qmsg;
	MLEFORMATRECT 	MLEFormatRect;

	if (argc >= 2)
		MakeQFN (argv[1], szCurrentFile, sizeof szCurrentFile);

	hab = WinInitialize (NULL);
	hmq = WinCreateMsgQueue (hab, DEFAULT_QUEUE_SIZE);

	WinRegisterClass (hab, szAppName, ClientWndProc, 0L, 0);

	hwndFrame = WinCreateStdWindow (HWND_DESKTOP, NULL, &flFrameFlags,
									szAppName, NULL, 0L, NULL,
									ID_RESOURCE, &hwndClient);

	if (CardCount == -1) {
		WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg2,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		WinDestroyWindow (hwndFrame);
		WinDestroyMsgQueue (hmq);
		WinTerminate (hab);
		return (1);
	}

	hwndButton[0] = WinCreateWindow (hwndClient, WC_BUTTON, "Srch",
							WS_VISIBLE | BS_PUSHBUTTON, cxChar * 1, cyChar/2,
							9 * cxChar, 2 * cyChar, hwndClient, HWND_BOTTOM,
							SRCH_BUTTON, NULL, NULL);

	hwndButton[1] = WinCreateWindow (hwndClient, WC_BUTTON, "Dial",
							WS_VISIBLE | BS_PUSHBUTTON, cxChar * 11, cyChar/2,
							9 * cxChar, 2 * cyChar, hwndClient, HWND_BOTTOM,
							DIAL_BUTTON, NULL, NULL);

	hwndButton[2] = WinCreateWindow (hwndClient, WC_BUTTON, "Prev",
							WS_VISIBLE | BS_PUSHBUTTON, cxChar * 36, cyChar/2,
							9 * cxChar, 2 * cyChar, hwndClient, HWND_BOTTOM,
							PREV_BUTTON, NULL, NULL);

	hwndButton[3] = WinCreateWindow (hwndClient, WC_BUTTON, "Next",
							WS_VISIBLE | BS_PUSHBUTTON, cxChar * 46, cyChar/2,
							9 * cxChar, 2 * cyChar, hwndClient, HWND_BOTTOM,
							NEXT_BUTTON, NULL, NULL);

	hwndMLE = WinCreateWindow (hwndClient, WC_MLE, "", WS_VISIBLE,
						cxChar, 3 * cyChar, 54 * cxChar, 8 * cyChar,
						hwndClient, HWND_BOTTOM, ID_MLE, NULL, NULL);

	WinSendMsg (hwndMLE, MLM_SETFORMATRECT, MPFROMP (&MLEFormatRect),
				MPFROMLONG (MLFFMTRECT_FORMATRECT));

	WinSendMsg (hwndMLE, MLM_FORMAT, MPFROMSHORT (MLFIE_NOTRANS), 0L);

	WinSendMsg (hwndMLE, MLM_SETTEXTCOLOR, MPFROMLONG ((COLOR) CLR_DARKBLUE), 0L);

	UpdateMLE ();

	while (TRUE) {
		while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
			WinDispatchMsg (hab, &qmsg);
		if (SaveBeforeExit (szCurrentFile) < 2)
			break;
		WinCancelShutdown (hmq, FALSE);
	}

	WinDestroyWindow (hwndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);

	return (0);
}

/*---------------------------------------------------------------------------
	UpdateMLE writes the text of the current card to the MLE.
---------------------------------------------------------------------------*/

VOID UpdateMLE (void)
{
	HPS		hps;
	LONG	lOffset = 0;

	WinSendMsg (hwndMLE, MLM_DELETE, MPFROMLONG (0L),
				MPFROMLONG (WinSendMsg (hwndMLE, MLM_QUERYTEXTLENGTH, 0L, 0L)));

	if (usCardLength[CardNo] != 0) {

		WinSendMsg (hwndMLE, MLM_SETIMPORTEXPORT,
					MPFROMP (chBufferPtr + usCardOffset[CardNo]),
					MPFROMSHORT (2048));

		WinSendMsg (hwndMLE, MLM_IMPORT, MPFROMP (&lOffset),
					MPFROMLONG ((LONG) usCardLength[CardNo]));
	}

	hps = WinGetPS (hwndClient);
	ShowCardNo (hps);
	WinReleasePS (hps);
}

/*---------------------------------------------------------------------------
	ShowCardNo displays "X of X" in the client window
---------------------------------------------------------------------------*/

VOID ShowCardNo (HPS hps)
{
	CHAR	szBuffer[32];
	RECTL	rcl;

	sprintf (szBuffer, "%u of %u", CardNo+1, CardCount);

	rcl.xLeft = 21 * cxChar;
	rcl.yBottom = cyChar/2;
	rcl.xRight = rcl.xLeft + (14 * cxChar);
	rcl.yTop = rcl.yBottom + (2 * cyChar);

	WinDrawText (hps, -1, szBuffer, &rcl, 0L, 0L,
				 DT_ERASERECT | DT_CENTER | DT_VCENTER | DT_TEXTATTRS);
}

/*---------------------------------------------------------------------------
	ReadFile reads a PMCARD data file from disk.

	Input:	szFileName = Pointer to ASCIIZ filename

	Return: 0 = Call succeeded
			1 = Error (file was not found or could not be opened)
			2 = Error (not a PMCARD data file)
---------------------------------------------------------------------------*/

USHORT ReadFile (CHAR *szFileName)
{
	USHORT		hFile, usAction, usBytesRead, i;
	FILESTATUS	fs;

	static CHAR	SigBuffer[] = { 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00 };

	if (DosOpen (szFileName, &hFile, &usAction, 0L, 0, FILE_OPEN,
			OPEN_ACCESS_READONLY | OPEN_SHARE_DENYREADWRITE, 0L))
		return (1);

	DosQFileInfo (hFile, 0x01, &fs, sizeof fs);

	DosRead (hFile, SigBuffer, 8, &usBytesRead);
	if (strncmp (SigBuffer, Signature, 8)) {
		DosClose (hFile);
		return (2);
	}

	DosRead (hFile, &CardCount, 2, &usBytesRead);
	DosRead (hFile, usCardLength, 2 * CardCount, &usBytesRead);
	DosRead (hFile, chBufferPtr, (USHORT) fs.cbFile - 10 -
			 (2 * (USHORT) CardCount), &usBytesRead);
	DosClose (hFile);

	usCardOffset[0] = 0;

	if (CardCount > 1)
		for (i=0; i<(CardCount-1); i++)
			usCardOffset[i+1] = usCardOffset[i] + usCardLength[i];

	usTopOffset = usCardOffset[CardCount-1] + usCardLength[CardCount-1];

	return (0);
}

/*---------------------------------------------------------------------------
	SaveFile saves a PMCARD data file to disk.

	Input:	szFileName = Pointer to ASCIIZ filename

	Return: 0 = Call succeeded
			1 = Error (invalid path or filename)
			2 = Error (disk full)
---------------------------------------------------------------------------*/

USHORT SaveFile (CHAR *szFileName)
{
	USHORT	hFile, usAction, usBytesWritten, i;

	if (DosOpen (szFileName, &hFile, &usAction, 0L, FILE_NORMAL,
				  FILE_TRUNCATE | FILE_CREATE, OPEN_ACCESS_WRITEONLY
				  | OPEN_SHARE_DENYREADWRITE, 0L))
		return (1);

	DosWrite (hFile, Signature, 8, &usBytesWritten);
	if (usBytesWritten < 8) {
		DosClose (hFile);
		return (2);
	}

	DosWrite (hFile, &CardCount, 2, &usBytesWritten);
	if (usBytesWritten < 2) {
		DosClose (hFile);
		return (2);
	}

	DosWrite (hFile, usCardLength, 2 * CardCount, &usBytesWritten);
	if (usBytesWritten < 2 * CardCount) {
		DosClose (hFile);
		return (2);
	}

	for (i=0; i<CardCount; i++)
		if (usCardLength[i] != 0) {
			DosWrite (hFile, chBufferPtr + usCardOffset[i], usCardLength[i],
					  &usBytesWritten);
			if (usBytesWritten < usCardLength[i]) {
				DosClose (hFile);
				return (2);
			}
		}

	DosClose (hFile);
	return (0);
}

/*---------------------------------------------------------------------------
	SaveBeforeExit invokes a dialog box that gives the user a chance to
	save a file before proceeding.  If the answer is yes, SaveBeforeExit
	calls SaveFile to save the file.

	Input:	szFileName = Pointer to ASCIIZ filename

	Return: 0 = User pressed "Yes"
			1 = User pressed "No"
			2 = User pressed "Cancel"
			3 = User pressed "Yes" but the file was not saved or
				ProcessCard failed for lack of buffer space
---------------------------------------------------------------------------*/

USHORT SaveBeforeExit (CHAR *szFileName)
{
	USHORT	usResult;

	switch (WinMessageBox (HWND_DESKTOP, hwndClient, szMsg1, " ", NULL,
						   MB_ICONQUESTION | MB_YESNOCANCEL)) {

	case MBID_YES:
		if (fEditing)
			if (ProcessCard (hwndButton[3]))
				return (3);

		if (strlen (szFileName) == 0)
			if (!WinDlgBox (HWND_DESKTOP, hwndClient, SaveAsDlgProc,
					NULL, IDD_SAVEAS, NULL))
				return (2);

		if ((usResult = SaveFile (szFileName)) != 0)

			switch (usResult) {

			case (1):
				strcpy (szTextBuffer, szFileName);
				strcat (szTextBuffer, szErrMsg8);
				WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
					NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				return (3);

			case (2):
				DosDelete (szFileName, 0L);
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg7,
					NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				return (3);
			}

		return (0);

	case MBID_NO:
		if (fEditing) {
			fEditing = FALSE;
			WinSetFocus (HWND_DESKTOP, hwndButton[3]);
		}
		return (1);

	case MBID_CANCEL:
		return (2);
	}
}

/*---------------------------------------------------------------------------
	PackBuffer packs the card data currently in the buffer.
---------------------------------------------------------------------------*/

VOID PackBuffer (void)
{
	USHORT	usSelector2, usOffset, i, j;
	CHAR	far *chPtr;

	if ((CardCount == 1) && (usCardLength[0] == 0))
		return;

	if (DosAllocSeg (usTopOffset+1, &usSelector2, 0))
		return;

	chPtr = (CHAR far *) (((ULONG)(usSelector2)) << 16);
	
	usOffset = 0;

	for (i=0; i<CardCount; i++)
		if (usCardLength[i] != 0) {
			for (j=0; j<usCardLength[i]; j++)
				*(chPtr + usOffset + j) = *(chBufferPtr + usCardOffset[i] + j);
			usOffset += usCardLength[i];
		}

	for (i=0; i<(usOffset+1); i++)
		*(chBufferPtr + i) = *(chPtr + i);

	usCardOffset[0] = 0;

	if (CardCount > 1)
		for (i=0; i<(CardCount-1); i++)
			usCardOffset[i+1] = usCardOffset[i] + usCardLength[i];

	usTopOffset = usCardOffset[CardCount-1] + usCardLength[CardCount-1];

	DosFreeSeg (usSelector2);
}

/*---------------------------------------------------------------------------
	ProcessCard processes the card currently in the MLE.

	Input:  hwnd = handle of window to receive the input focus

	Return: 0 = Call succeeded
			1 = Error (Not enough buffer space)
---------------------------------------------------------------------------*/

USHORT ProcessCard (HWND hwnd)
{
	LONG		lOffset = 0;
	ULONG		ulByteCount;
	USHORT		usCardSize;
	CHAR		chFirstChar;

	ulByteCount = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYTEXTLENGTH, 0L, 0L);
	usCardSize = (USHORT) ulByteCount;

	if (usCardSize == usCardLength[CardNo]) {
		usCardLength[CardNo] = usCardSize;
		chFirstChar = *(chBufferPtr + usCardOffset[CardNo] + usCardSize);

		WinSendMsg (hwndMLE, MLM_SETIMPORTEXPORT,
					MPFROMP (chBufferPtr + usCardOffset[CardNo]),
					MPFROMSHORT (2048));

		WinSendMsg (hwndMLE, MLM_EXPORT, MPFROMP (&lOffset),
					MPFROMP (&ulByteCount));

		*(chBufferPtr + usCardOffset[CardNo] + usCardSize) = chFirstChar;

		WinSetFocus (HWND_DESKTOP, hwnd);
		fEditing = FALSE;
		return (0);
	}

	if (usCardSize < usCardLength[CardNo]) {
		usCardLength[CardNo] = usCardSize;

		WinSendMsg (hwndMLE, MLM_SETIMPORTEXPORT,
					MPFROMP (chBufferPtr + usCardOffset[CardNo]),
					MPFROMSHORT (2048));

		WinSendMsg (hwndMLE, MLM_EXPORT, MPFROMP (&lOffset),
					MPFROMP (&ulByteCount));

		WinSetFocus (HWND_DESKTOP, hwnd);
		fEditing = FALSE;
		return (0);
	}

	if (ulByteCount > (0xFFFE - usTopOffset)) {
		WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg9,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		return (1);
	}

	usCardLength[CardNo] = usCardSize;

	WinSendMsg (hwndMLE, MLM_SETIMPORTEXPORT,
				MPFROMP (chBufferPtr + usTopOffset),
				MPFROMSHORT (2048));

	WinSendMsg (hwndMLE, MLM_EXPORT, MPFROMP (&lOffset),
				MPFROMP (&ulByteCount));

	usCardOffset[CardNo] = usTopOffset;
	usTopOffset += usCardSize;
	WinSetFocus (HWND_DESKTOP, hwnd);
	fEditing = FALSE;
	return (0);
}

/*---------------------------------------------------------------------------
	DialPhone dials the phone number whose address is passed.

	Input:	szPhone = Pointer to ASCIIZ phone number string

	Return:	0 = Call succeeded
			1 = Error (COM port not available)
			2 = Error (Modem not ready)
			3 = Error (Write error)
---------------------------------------------------------------------------*/

USHORT DialPhone (CHAR *szPhone)
{
	DCBINFO			DCBInfo;
	LINECONTROL 	lc;
	static USHORT	usBaudRate[5] = { 300, 1200, 2400, 4800, 9600 };
	static CHAR		*szCOMPortID[4] = { "COM1", "COM2", "COM3", "COM4" };
	USHORT			hFile, usAction, usBytesWritten, usLineStatus;
	static CHAR		szBuffer[41];
	static CHAR		szEOL[3] = { 0x3B, 0x0D, 0x00 };

	if (DosOpen (szCOMPortID[GblParms.COMPort], &hFile, &usAction, 0L,
		FILE_NORMAL, FILE_OPEN, OPEN_ACCESS_READWRITE |
		OPEN_SHARE_DENYREADWRITE, 0L)) {

		strcpy (szTextBuffer, szCOMPortID[GblParms.COMPort]);
		strcat (szTextBuffer, szErrMsg12);
		WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		return (1);
	}

	DosDevIOCtl (&usLineStatus, 0L, ASYNC_GETMODEMINPUT, 0x01, hFile);

	if ((usLineStatus & CTS_ON) == 0) {
		WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg13,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		DosClose (hFile);
		return (2);
	}

	DosDevIOCtl (0L, &usBaudRate[GblParms.BaudRate],
				 ASYNC_SETBAUDRATE, 0x01, hFile);

	lc.bDataBits = (BYTE) GblParms.DataBits + 7;
	lc.bParity = (BYTE) GblParms.Parity;
	lc.bStopBits = (BYTE) GblParms.StopBits * 2;
	DosDevIOCtl (0L, &lc, ASYNC_SETLINECTRL, 0x01, hFile);

	DosDevIOCtl (&DCBInfo, 0L, ASYNC_GETDCBINFO, 0x01, hFile);
	DCBInfo.usWriteTimeout = 100;
	DCBInfo.fbCtlHndShake = 0 | MODE_DTR_CONTROL;
	DCBInfo.fbFlowReplace = 0 | MODE_RTS_CONTROL;
	DosDevIOCtl (0L, &DCBInfo, ASYNC_SETDCBINFO, 0x01, hFile);

	strcpy (szBuffer, szDialCmd);
	strcat (szBuffer, szDialPrefix);
	strcat (szBuffer, szPhone);
	strcat (szBuffer, szEOL);

	if (DosWrite (hFile, szBuffer, strlen (szBuffer), &usBytesWritten)) {
		WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg14,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		DosClose (hFile);
		return (3);
	}

	WinMessageBox (HWND_DESKTOP, hwndClient, szMsg2, " ", NULL, MB_OK);

	strcpy (szBuffer, szHangUpCmd);
	strcat (szBuffer, &szEOL[1]);

	if (DosWrite (hFile, szBuffer, strlen (szBuffer), &usBytesWritten)) {
		WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg14,
					   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
		DosClose (hFile);
		return (3);
	}

	DosClose (hFile);
	return (0);
}

/*---------------------------------------------------------------------------
	BuildPhoneList builds a list of phone numbers from the text of the
	current card.

	Input:	szBuffer = Pointer to list buffer

	Return:	Number of entries in list
---------------------------------------------------------------------------*/

USHORT BuildPhoneList (CHAR *szBuffer)
{
	USHORT	usDigits, usChars, usCount = 0, i = 0;
	CHAR	chFirstChar;

	if (usCardLength[CardNo] < 6)
		return (0);	

	chFirstChar = *(chBufferPtr + usCardOffset[CardNo] +
			usCardLength[CardNo]);

	*(chBufferPtr + usCardOffset[CardNo] + usCardLength[CardNo]) = 0x0A;

	while ((i <= usCardLength[CardNo]-5) && (usCount < 10)) {

		if ((*(chBufferPtr+usCardOffset[CardNo]+i) < 0x30) ||
		    (*(chBufferPtr+usCardOffset[CardNo]+i) > 0x39)) {
			i++;
			continue;
		}

		CountDigits (chBufferPtr+usCardOffset[CardNo]+i, &usDigits, &usChars);

		if (usDigits < 5) {
			i++;
			continue;
		}

		if ((usDigits == 5) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+1) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+1) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+2) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+2) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+3) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+3) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+4) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+4) <= 0x39)) {
				i += usChars;
				continue;
		}

		if ((usDigits == 9) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+1) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+1) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+2) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+2) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+3) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+3) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+4) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+4) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+5) == 0x2D) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+6) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+6) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+7) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+7) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+8) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+8) <= 0x39) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+9) >= 0x30) &&
			(*(chBufferPtr+usCardOffset[CardNo]+i+9) <= 0x39)) {
				i += usChars;
				continue;
		}

		CopyToList (usChars, szBuffer+(usCount*20),
					chBufferPtr+usCardOffset[CardNo]+i);
		i += usChars;
		usCount++;
	}

	*(chBufferPtr + usCardOffset[CardNo] + usCardLength[CardNo])
		= chFirstChar;

	return (usCount);
}

/*---------------------------------------------------------------------------
	CountDigits counts the number of consecutive digits in a string
	ignoring spaces, commas, hyphens, and parentheses.

	Input:	szBuffer = Pointer to text string
			usDigits = Pointer to variable to receive digit count
			usChars = Pointer to variable to receive raw character count

	Return:	usDigits = Number of consecutive digits
			usChars = Number of characters comprising those digits
---------------------------------------------------------------------------*/

VOID CountDigits (CHAR far *szBuffer, USHORT *usDigits, USHORT *usChars)
{
	CHAR	ch;

	*usDigits = *usChars = 0;

	while (TRUE) {
		ch = *szBuffer++;
		if ((ch >= 0x30) && (ch <= 0x39)) {
			(*usDigits)++;
			(*usChars)++;
		}
		else
			if ((ch == 0x20) || (ch == 0x2D) ||
			    (ch == 0x28) || (ch == 0x29) ||
				(ch == 0x2C))
				(*usChars)++;
			else
				break;
	}
}

/*---------------------------------------------------------------------------
	CopyToList copies a string from one location to another and
	filters out non-numeric characters in the process.

	Input:	usChars = Number of characters to process
			szDest = Pointer to destination buffer
			szSource = Pointer to source string
---------------------------------------------------------------------------*/

VOID CopyToList (USHORT usChars, CHAR *szDest, CHAR far *szSource)
{
	USHORT	i, usCount = 0;

	for (i=0; i<usChars && usCount<16; i++)
		if (((*szSource >= 0x30) && (*szSource <= 0x39)) ||
			 (*szSource == 0x2C)) {
			*szDest++ = *szSource++;
			usCount++;
		}
		else
			*szSource++;

	*szDest = 0x00;
}


/*---------------------------------------------------------------------------
	FindPrevCard finds the last card that meets the search criteria.

	Return:	0 = No matching card found
			1 = Match found (CardNo set to card number)
---------------------------------------------------------------------------*/

USHORT FindPrevCard (void)
{
	SHORT	CurrentCard, CardsSearched = 0;

	CurrentCard = (CardNo == 0) ? CardCount-1 : CardNo-1;

	while (CardsSearched++ < CardCount)
		if (CheckCard (CurrentCard) != 0) {
			CardNo = CurrentCard;
			return (1);
		}
		else
			CurrentCard = (CurrentCard == 0) ? CardCount-1 : CurrentCard-1;

	return (0);
}

/*---------------------------------------------------------------------------
	FindNextCard finds the next card that meets the search criteria.

	Return:	0 = No matching card found
			1 = Match found (CardNo set to card number)
---------------------------------------------------------------------------*/

USHORT FindNextCard (void)
{
	SHORT	CurrentCard, CardsSearched = 0;

	CurrentCard = (CardNo == CardCount-1) ? 0 : CardNo+1;

	while (CardsSearched++ < CardCount)
		if (CheckCard (CurrentCard) != 0) {
			CardNo = CurrentCard;
			return (1);
		}
		else
			CurrentCard = (CurrentCard == CardCount-1) ? 0 : CurrentCard + 1;

	return (0);
}

/*---------------------------------------------------------------------------
	CheckCard checks a card for a search string.

	Input:	usCurrentCard = Card number to check

	Return:	0 = Card does not contain the search text
			1 = Card does contain the search text
---------------------------------------------------------------------------*/

USHORT CheckCard (USHORT usCurrentCard)
{
	USHORT	i, usSearchLength;

	if ((usSearchLength = strlen (szSearchText)) > usCardLength[usCurrentCard])
		return (0);

	if (fCaseSensitive) {
		for (i=0; i < (usCardLength[usCurrentCard] - usSearchLength + 1); i++)
			if (strncmp (szSearchText, chBufferPtr + usCardOffset[usCurrentCard] + i,
				usSearchLength) == 0)
					return (1);
	}
	else {
		for (i=0; i < (usCardLength[usCurrentCard] - usSearchLength + 1); i++)
			if (strnicmp (szSearchText, chBufferPtr + usCardOffset[usCurrentCard] + i,
				usSearchLength) == 0)
					return (1);
	}

	return (0);
}

/*---------------------------------------------------------------------------
	FillDriveListBox fills a list box with letters identifying all
	currently defined drives.

	Input:	hwnd = Handle of window where list box appears
			id = List box ID
---------------------------------------------------------------------------*/

VOID FillDriveListBox (HWND hwnd, USHORT id)
{
	USHORT		usCurrentDrive, i;
	ULONG		ulDriveMap;
	static CHAR	szDriveID[] = " ::";

	DosQCurDisk (&usCurrentDrive, &ulDriveMap);
	WinSendDlgItemMsg (hwnd, id, LM_DELETEALL, NULL, NULL);

	for (i=0; i<26; i++)

		if (ulDriveMap & (1L << i)) {

			szDriveID[1] = (CHAR) i + 0x41;
			WinSendDlgItemMsg (hwnd, id, LM_INSERTITEM,
							   MPFROM2SHORT (LIT_END, 0),
							   MPFROMP (szDriveID));
		}
}

/*---------------------------------------------------------------------------
	FillDirListBox fills a list box with strings identifying all
	directories stemming from the current directory.

	Input:	hwnd = Handle of window where list box appears
			id = List box ID
---------------------------------------------------------------------------*/

VOID FillDirListBox (HWND hwnd, USHORT id)
{
	HDIR		hDir = HDIR_CREATE;
	FILEFINDBUF	FileFindBuf;
	USHORT		usSearchCount = 1;

	DosFindFirst ("*.*", &hDir, FILE_DIRECTORY, &FileFindBuf,
			      sizeof FileFindBuf, &usSearchCount, 0L);

	WinSendDlgItemMsg (hwnd, id, LM_DELETEALL, NULL, NULL);

	while (usSearchCount) {

		if (((FileFindBuf.attrFile & FILE_DIRECTORY) != 0) &&
			 (strcmp(FileFindBuf.achName, ".") != 0))

			WinSendDlgItemMsg (hwnd, id, LM_INSERTITEM,
							   MPFROM2SHORT (LIT_SORTASCENDING, 0),
							   MPFROMP (FileFindBuf.achName));

		DosFindNext (hDir, &FileFindBuf, sizeof FileFindBuf, &usSearchCount);
	}
	DosFindClose (hDir);
}

/*---------------------------------------------------------------------------
	FillFileListBox fills a list box with strings identifying all
	files present in the current directory.

	Input:	hwnd = Handle of window where list box appears
			id = List box ID
---------------------------------------------------------------------------*/

VOID FillFileListBox (HWND hwnd, USHORT id)
{
	HDIR		hDir = HDIR_CREATE;
	FILEFINDBUF	FileFindBuf;
	USHORT		usSearchCount = 1;

	DosFindFirst ("*.*", &hDir, FILE_NORMAL, &FileFindBuf,
			      sizeof (FileFindBuf), &usSearchCount, 0L);

	WinSendDlgItemMsg (hwnd, id, LM_DELETEALL, NULL, NULL);

	while (usSearchCount) {

		WinSendDlgItemMsg (hwnd, id, LM_INSERTITEM,
						   MPFROM2SHORT (LIT_SORTASCENDING, 0),
						   MPFROMP (FileFindBuf.achName));

		DosFindNext (hDir, &FileFindBuf, sizeof (FileFindBuf), &usSearchCount);
	}
	DosFindClose (hDir);
}

/*---------------------------------------------------------------------------
	MakePath constructs an ASCIIZ string denoting the current path.

	Input:	szDest = Pointer to buffer where string will be placed
			cbDest = size of buffer where path will be stored

	Return:	0 = Call succeeded
			1 = Error (buffer too small)

---------------------------------------------------------------------------*/

USHORT MakePath (CHAR *szDest, USHORT cbDest)
{
	USHORT		usCurrentDrive, usBufferSize;
	ULONG		ulDriveMap;

	usBufferSize = cbDest - 3;

	DosQCurDisk (&usCurrentDrive, &ulDriveMap);
	*szDest++ = (CHAR) usCurrentDrive + 0x40;
	*szDest++ = 0x3A;
	*szDest++ = 0x5C;

	if (DosQCurDir (usCurrentDrive, szDest, &usBufferSize))
		return (1);

	return (0);
}

/*---------------------------------------------------------------------------
	MakeQFN	generates a fully qualified filename from a filename string.

	Input:	szSource = Pointer to original filename
			szDest = Pointer to buffer where QFN will be stored
			usSize = Size of buffer where QFN will be stored

	Return:	0 = Call succeeded
			1 = Error (QFN buffer too small)
---------------------------------------------------------------------------*/

USHORT MakeQFN (CHAR *szSource, CHAR *szDest, USHORT usSize)
{
	USHORT	usCurrentDrive, usPathlen;
	ULONG	ulDriveMap;
	CHAR	*chPtr;

	chPtr = szDest;
	usPathlen = usSize - 3;
	DosQCurDisk (&usCurrentDrive, &ulDriveMap);

	if (szSource[1] == 0x3A && strlen (szSource) > 1 ) {
		*szDest++ = *szSource++;
		*szDest++ = *szSource++;
	}
	else {
		*szDest++ = (CHAR) usCurrentDrive + 0x40;
		*szDest++ = 0x3A;
	}

	*szDest = 0x00;

	if (szSource[0] != 0x5C) {
		*szDest++ = 0x5C;
		if (DosQCurDir (usCurrentDrive, szDest, &usPathlen))
			return (1);
		if (szDest[strlen(szDest)-1] != 0x5C)
			strcat (szDest, "\\");
	}

	strcat (szDest, szSource);
	strupr (chPtr);
	return (0);
}

/*---------------------------------------------------------------------------
	ExtractFileName extracts a filename from a fully qualified filename

	Input:	szSource = Pointer to original filename
			szDest = Pointer to buffer where filename will be stored
---------------------------------------------------------------------------*/

VOID ExtractFileName (CHAR *szSource, CHAR *szDest)
{
	SHORT	i;

	if (szSource[0] == 0x00)
		szDest[0] = 0x00;
	else {
		for (i=strlen(szSource)-1; szSource[i] != 0x5C; i--);
		strncpy (szDest, &szSource[i+1], strlen(szSource)-i+1);
	}
}

/*---------------------------------------------------------------------------
	ClientWndProc processes messages sent to the client window.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY ClientWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	static HWND	hwndFrame;
	static HWND hwndMenu;
	static HPS	hps;
	FONTMETRICS	fm;
	USHORT		usResult, usInfo, i;
	SHORT		cxWidth, cyHeight, j;
	ULONG		ulReturn, ulBytesCopied, ulTextLength;
	CHAR		achBuffer[64];

	switch (msg) {

	case WM_CREATE:
		hwndFrame = WinQueryWindow (hwnd, QW_PARENT, FALSE);
		hwndMenu = WinWindowFromID (hwndFrame, FID_MENU);
		WinSetWindowText (hwndFrame, szAppName);

		if (DosAllocSeg (0xFFFF, &usSelector1, 0)) {
			CardCount = -1;
			return (0);
		}

		chBufferPtr = (CHAR far *) (((ULONG)(usSelector1)) << 16);

		WinQueryProfileData (hab, szAppName, szKeyName1, &GblParms, &i);
		WinQueryProfileString (hab, szAppName, szKeyName2, "ATS11=55DT",
							   szDialCmd, sizeof (szDialCmd));
		WinQueryProfileString (hab, szAppName, szKeyName3, "ATH0",
							   szHangUpCmd, sizeof (szHangUpCmd));
		WinQueryProfileString (hab, szAppName, szKeyName4, "",
							   szDefDataFile, sizeof (szDefDataFile));
		WinQueryProfileString (hab, szAppName, szKeyName5, "",
							   szDialPrefix, sizeof (szDialPrefix));

		if ((strlen (szDefDataFile) != 0) && (strlen (szCurrentFile) == 0))
			MakeQFN (szDefDataFile, szCurrentFile, sizeof szCurrentFile);

		if (strlen (szCurrentFile) != 0)
			if ((i = ReadFile (szCurrentFile)) != 0)
				switch (i) {

				case (1):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg1);
					WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					break;

				case (2):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg6);
					WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					break;
				}

		hps = WinGetPS (hwnd);
		GpiQueryFontMetrics (hps, (LONG) sizeof fm, &fm);
		cxChar = (SHORT) fm.lAveCharWidth;
		cyChar = (SHORT) fm.lMaxBaselineExt - (SHORT) fm.lMaxDescender;
		WinReleasePS (hps);

		cyHeight = (cyChar * 11) + (SHORT) WinQuerySysValue (HWND_DESKTOP, SV_CYTITLEBAR)
						 + (SHORT) WinQuerySysValue (HWND_DESKTOP, SV_CYMENU)
						 + (2 * (SHORT) WinQuerySysValue (HWND_DESKTOP, SV_CYBORDER));

		cxWidth = (cxChar * 56) + (2 * (SHORT) WinQuerySysValue (HWND_DESKTOP, SV_CXBORDER));

		WinSetWindowPos (hwndFrame, HWND_TOP, 0, 0, cxWidth, cyHeight,
						 SWP_SIZE | SWP_SHOW);

		return (0);

	case WM_PAINT:
		hps = WinBeginPaint (hwnd, NULL, NULL);
		GpiErase (hps);
		ShowCardNo (hps);
		WinEndPaint (hps);
		return (0);

	case WM_INITMENU:

		switch (SHORT1FROMMP (mp1)) {

		case IDM_EDIT:
			ulReturn = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYSEL,
									(MPARAM) MLFQS_MINMAXSEL, 0L);

			if ((USHORT) (ulReturn & 0xFFFF) != (USHORT) (ulReturn >> 16)) {
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_CUT, TRUE),
							MPFROM2SHORT (MIA_DISABLED, 0));
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_COPY, TRUE),
							MPFROM2SHORT (MIA_DISABLED, 0));
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_CLEAR, TRUE),
							MPFROM2SHORT (MIA_DISABLED, 0));
			}
			else {
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_CUT, TRUE),
							MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_COPY, TRUE),
							MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_CLEAR, TRUE),
							MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));
			}

			if (WinQueryClipbrdFmtInfo (hab, CF_TEXT, &usInfo))
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_PASTE, TRUE),
							MPFROM2SHORT (MIA_DISABLED, 0));
			else
				WinSendMsg (hwndMenu, MM_SETITEMATTR,
							MPFROM2SHORT (IDM_PASTE, TRUE),
							MPFROM2SHORT (MIA_DISABLED, MIA_DISABLED));

			WinSendMsg (hwndMenu, MM_SETITEMATTR,
						MPFROM2SHORT (IDM_UNDODELETE, TRUE),
						MPFROM2SHORT (MIA_DISABLED, 
							fCardInBuffer ? 0 : MIA_DISABLED));

			return (0);

		case IDM_OPTIONS:
			WinSendMsg (hwndMenu, MM_SETITEMATTR,
						MPFROM2SHORT (IDM_FINDPREV, TRUE),
						MPFROM2SHORT (MIA_DISABLED,
							(strlen (szSearchText) != 0) ? 0 : MIA_DISABLED));

			WinSendMsg (hwndMenu, MM_SETITEMATTR,
						MPFROM2SHORT (IDM_FINDNEXT, TRUE),
						MPFROM2SHORT (MIA_DISABLED,
							(strlen (szSearchText) != 0) ? 0 : MIA_DISABLED));

			return (0);
		}
		break;

	case WM_CHAR:
		if (CHARMSG (&msg) -> fs & KC_KEYUP)
			return (0);

		if (CHARMSG (&msg) -> fs & KC_VIRTUALKEY)

			switch (CHARMSG (&msg) -> vkey) {

			case VK_PAGEUP:
				if (fEditing)
					if (ProcessCard (hwndButton[2]))
						break;
				CardNo = (CardNo == 0) ? CardCount-1 : CardNo-1;
				UpdateMLE ();
				break;

			case VK_PAGEDOWN:
				if (fEditing)
					if (ProcessCard (hwndButton[3]))
						break;
				CardNo = (CardNo == CardCount-1) ? 0 : CardNo+1;
				UpdateMLE ();
				break;
			}

		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case SRCH_BUTTON:
			if (fEditing)
				if (ProcessCard (hwndButton[0]))
					return (0);

			if (WinDlgBox (HWND_DESKTOP, hwnd, SearchDlgProc, NULL,
						   IDD_SEARCH, NULL)) {

				if (strlen (szSearchText) != 0) {
					if (FindNextCard() != 0)
						UpdateMLE ();
					else {
						strcpy (szTextBuffer, "\"");
						strcat (szTextBuffer, szSearchText);
						strcat (szTextBuffer, "\"");
						strcat (szTextBuffer, szErrMsg4);
						WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					}
				}
			}

			return (0);

		case DIAL_BUTTON:
			if (fEditing)
				if (ProcessCard (hwndButton[1]))
					return (0);

			ulTextLength = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYSEL,
									(MPARAM) MLFQS_MINMAXSEL, 0L);

			if ((ulTextLength >> 16) - (ulTextLength & 0xFFFF) >
				sizeof (achBuffer)) {
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg15,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				WinSetFocus (HWND_DESKTOP, hwndMLE);
				return (0);
			}

			ulBytesCopied = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYSELTEXT,
										MPFROMP (achBuffer), 0L);

			if (ulBytesCopied > 1) {
				CopyToList (strlen (achBuffer), szPhoneNumber, achBuffer);
				DialPhone (szPhoneNumber);
				WinSetFocus (HWND_DESKTOP, hwndMLE);
			}
			else {
				usPhoneCount = BuildPhoneList (szPhoneList);
				if (WinDlgBox (HWND_DESKTOP, hwnd, DialDlgProc, NULL, IDD_DIAL, NULL))
					DialPhone (szPhoneNumber);
			}

			return (0);

		case PREV_BUTTON:
			if (fEditing)
				if (ProcessCard (hwndButton[2]))
					return (0);
			CardNo = (CardNo == 0) ? CardCount-1 : CardNo-1;
			UpdateMLE ();
			return (0);

		case NEXT_BUTTON:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);
			CardNo = (CardNo == CardCount-1) ? 0 : CardNo+1;
			UpdateMLE ();
			return (0);

		case IDM_NEW:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if (SaveBeforeExit (szCurrentFile) > 1)
				return (0);

			CardCount = 1;
			CardNo = usCardLength[0] = usCardOffset[0] = usTopOffset = 0;
			szCurrentFile[0] = 0;
			UpdateMLE ();
			return (0);

		case IDM_OPEN:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if ((CardCount > 1) || (usCardLength[0] > 0))
				if (SaveBeforeExit (szCurrentFile) > 1)
					return (0);

			if (WinDlgBox (HWND_DESKTOP, hwnd, OpenDlgProc, NULL,
						   IDD_OPEN, NULL)) {

				if ((usResult = ReadFile (szCurrentFile)) == 0) {
					CardNo = 0;
					UpdateMLE ();
				}
				else
					switch (usResult) {

					case (1):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg1);
						WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
						break;

					case (2):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg6);
						WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
						break;
					}
			}

			return (0);

		case IDM_SAVE:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if (szCurrentFile[0] == 0x00)
				if (!WinDlgBox (HWND_DESKTOP, hwnd, SaveAsDlgProc, NULL,
							   IDD_SAVEAS, NULL))
					return (0);

			if ((usResult = SaveFile (szCurrentFile)) != 0)

				switch (usResult) {

				case (1):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg8);
					WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					break;

				case (2):
					DosDelete (szCurrentFile, 0L);
					WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg7,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				}

			PackBuffer ();
			return (0);

		case IDM_SAVEAS:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if (!WinDlgBox (HWND_DESKTOP, hwnd, SaveAsDlgProc, NULL,
						   IDD_SAVEAS, NULL))
				return (0);

			if ((usResult = SaveFile (szCurrentFile)) != 0)

				switch (usResult) {

				case (1):
					strcpy (szTextBuffer, szCurrentFile);
					strcat (szTextBuffer, szErrMsg8);
					WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					break;

				case (2):
					DosDelete (szCurrentFile, 0L);
					WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg7,
								   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					break;
				}

			PackBuffer ();
			return (0);

		case IDM_EXIT:
			WinSendMsg (hwnd, WM_CLOSE, 0L, 0L);
			return (0);

		case IDM_CUT:
			WinSendMsg (hwndMLE, MLM_CUT, 0L, 0L);
			return (0);

		case IDM_COPY:
			WinSendMsg (hwndMLE, MLM_COPY, 0L, 0L);
			return (0);

		case IDM_PASTE:
			if (fEditing)
				WinSendMsg (hwndMLE, MLM_PASTE, 0L, 0L);
			else
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg10,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
			return (0);

		case IDM_CLEAR:
			WinSendMsg (hwndMLE, MLM_CLEAR, 0L, 0L);
			return (0);

		case IDM_DELCARD:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			fCardInBuffer = TRUE;
			usDeletedTextLength = usCardLength[CardNo];

			if (usCardLength[CardNo] != 0)
				for (i=0; i<usDeletedTextLength; i++)
					chDeleteBuffer[i] = *(chBufferPtr + usCardOffset[CardNo] + i);

			if (CardCount == 1)
				usCardLength[0] = usCardOffset[0] = 0;
			else
				if (CardNo == --CardCount)
					CardNo = 0;
				else
					for (i=CardNo; i<CardCount; i++) {
						usCardOffset[i] = usCardOffset[i+1];
						usCardLength[i] = usCardLength[i+1];
					}

			UpdateMLE ();
			return (0);			

		case IDM_UNDODELETE:
			if (CardCount == 999) {
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg3,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				return (0);
			}

			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if (usDeletedTextLength > (0xFFFE - usTopOffset)) {
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg11,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				return (0);
			}

			for (j=CardCount-1; j>=CardNo; j--) {
				usCardOffset[j+1] = usCardOffset[j];
				usCardLength[j+1] = usCardLength[j];
			}

			usCardOffset[CardNo] = usTopOffset;
			usCardLength[CardNo] = usDeletedTextLength;
			usTopOffset += usDeletedTextLength;
			CardCount++;

			if (usCardLength[CardNo] != 0)
				for (i=0; i<usDeletedTextLength; i++)
					*(chBufferPtr + usCardOffset[CardNo] + i) = chDeleteBuffer[i];

			UpdateMLE ();
			return (0);

		case IDM_INSERTCARD:
			if (CardCount == 999) {
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg3,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				return (0);
			}

			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			for (j=CardCount-1; j>=CardNo; j--) {
				usCardOffset[j+1] = usCardOffset[j];
				usCardLength[j+1] = usCardLength[j];
			}

			usCardOffset[CardNo] = 0;
			usCardLength[CardNo] = 0;
			CardCount++;
			UpdateMLE ();
			return (0);

		case IDM_SEARCH:
			if (fEditing)
				if (ProcessCard (hwndButton[0]))
					return (0);

			if (WinDlgBox (HWND_DESKTOP, hwnd, SearchDlgProc, NULL,
						   IDD_SEARCH, NULL)) {

				if (strlen (szSearchText) != 0) {
					if (FindNextCard() != 0) {
						UpdateMLE ();
						WinSetFocus (HWND_DESKTOP, hwndButton[1]);
					}
					else {
						strcpy (szTextBuffer, "\"");
						strcat (szTextBuffer, szSearchText);
						strcat (szTextBuffer, "\"");
						strcat (szTextBuffer, szErrMsg4);
						WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
					}
				}
			}

			return (0);

		case IDM_FINDPREV:
			if (fEditing)
				if (ProcessCard (hwndButton[0]))
					return (0);

			if (FindPrevCard() != 0)
				UpdateMLE ();
			else {
				strcpy (szTextBuffer, "\"");
				strcat (szTextBuffer, szSearchText);
				strcat (szTextBuffer, "\"");
				strcat (szTextBuffer, szErrMsg4);
				WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
			}

			return (0);

		case IDM_FINDNEXT:
			if (fEditing)
				if (ProcessCard (hwndButton[0]))
					return (0);

			if (FindNextCard() != 0)
				UpdateMLE ();
			else {
				strcpy (szTextBuffer, "\"");
				strcat (szTextBuffer, szSearchText);
				strcat (szTextBuffer, "\"");
				strcat (szTextBuffer, szErrMsg4);
				WinMessageBox (HWND_DESKTOP, hwndClient, szTextBuffer,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
			}

			return (0);

		case IDM_GOTO:
			if (fEditing)
				if (ProcessCard (hwndButton[3]))
					return (0);

			if (WinDlgBox (HWND_DESKTOP, hwnd, GotoDlgProc,
				NULL, IDD_GOTO, NULL))
				UpdateMLE ();

			return (0);

		case IDM_DIAL:
			if (fEditing)
				if (ProcessCard (hwndButton[1]))
					return (0);

			ulTextLength = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYSEL,
									(MPARAM) MLFQS_MINMAXSEL, 0L);

			if ((ulTextLength >> 16) - (ulTextLength & 0xFFFF) >
				sizeof (achBuffer)) {
				WinMessageBox (HWND_DESKTOP, hwndClient, szErrMsg15,
							   NULL, NULL, MB_ICONEXCLAMATION | MB_OK);
				WinSetFocus (HWND_DESKTOP, hwndMLE);
				return (0);
			}

			ulBytesCopied = (ULONG) WinSendMsg (hwndMLE, MLM_QUERYSELTEXT,
										MPFROMP (achBuffer), 0L);

			if (ulBytesCopied > 1) {
				CopyToList (strlen (achBuffer), szPhoneNumber, achBuffer);
				DialPhone (szPhoneNumber);
				WinSetFocus (HWND_DESKTOP, hwndMLE);
			}
			else {
				usPhoneCount = BuildPhoneList (szPhoneList);
				if (WinDlgBox (HWND_DESKTOP, hwnd, DialDlgProc, NULL, IDD_DIAL, NULL))
					DialPhone (szPhoneNumber);
			}

			return (0);

		case IDM_MEMORY:
			WinDlgBox (HWND_DESKTOP, hwnd, StatusDlgProc,
					   NULL, IDD_MEMORY, NULL);
			return (0);

		case IDM_SETTINGS:
			WinDlgBox (HWND_DESKTOP, hwnd, ConfigDlgProc,
					   NULL, IDD_SETTINGS, NULL);
			return (0);

		case IDM_ABOUT:
			WinDlgBox (HWND_DESKTOP, hwnd, AboutDlgProc,
					   NULL, IDD_ABOUT, NULL);
			return (0);
		}
		break;

	case WM_CONTROL:

		switch (SHORT2FROMMP (mp1)) {

		case MLN_SETFOCUS:
			fEditing = TRUE;
			return (0);
		}
		break;
	}

	return (WinDefWindowProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	AboutDlgProc processes messages sent to the About dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY AboutDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	switch (msg) {

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
		case DID_CANCEL:
			WinDismissDlg (hwnd, TRUE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	SearchDlgProc processes messages sent to the Search dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY SearchDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	switch (msg) {

	case WM_INITDLG:
		WinSendDlgItemMsg (hwnd, IDD_SEARCHTEXT, EM_SETTEXTLIMIT,
					    MPFROM2SHORT (40, 0), NULL);
		WinSetDlgItemText (hwnd, IDD_SEARCHTEXT, szSearchText);
		WinSendDlgItemMsg (hwnd, IDD_CHECKCASE, BM_SETCHECK,
						   MPFROM2SHORT (fCaseSensitive, 0), NULL);

		return (0);

	case WM_CONTROL:
		if (SHORT1FROMMP (mp1) == IDD_CHECKCASE)
			fCaseSensitive = fCaseSensitive ? FALSE : TRUE;
		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_SEARCHTEXT, 40, szSearchText);
			WinDismissDlg (hwnd, TRUE);
			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	SaveAsDlgProc processes messages sent to the Save As dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY SaveAsDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	SHORT		Index;
	static CHAR	szPath[255];

	switch (msg) {

	case WM_INITDLG:
		FillDriveListBox (hwnd, IDD_DRIVELIST2);
		FillDirListBox (hwnd, IDD_DIRLIST2);
		WinSendDlgItemMsg (hwnd, IDD_NEWFILENAME, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (254, 0), NULL);
		ExtractFileName (szCurrentFile, szPath);
		WinSetDlgItemText (hwnd, IDD_NEWFILENAME, szPath);
		WinSendMsg (WinWindowFromID (hwnd, IDD_NEWFILENAME),
					EM_SETSEL, MPFROM2SHORT (0, 255), 0L);
		MakePath (szPath, sizeof szPath);
		WinSetDlgItemText (hwnd, IDD_DIRECTORY2, szPath);
		return (0);

	case WM_CONTROL:
		switch (SHORT1FROMMP (mp1)) {

		case IDD_DRIVELIST2:
			switch (SHORT2FROMMP (mp1)) {

			case LN_ENTER:
				Index = (SHORT) WinSendDlgItemMsg (hwnd, IDD_DRIVELIST2,
													LM_QUERYSELECTION, 0L, 0L);

				WinSendDlgItemMsg (hwnd, IDD_DRIVELIST2, LM_QUERYITEMTEXT,
								   MPFROM2SHORT (Index, sizeof (szPath)),
								   MPFROMP (szPath));

				DosSelectDisk ((USHORT) szPath[1] - 0x40);
				MakePath (szPath, sizeof szPath);
				WinSetDlgItemText (hwnd, IDD_DIRECTORY2, szPath);
				FillDirListBox (hwnd, IDD_DIRLIST2);
				return (0);
			}
			break;

		case IDD_DIRLIST2:
			switch (SHORT2FROMMP (mp1)) {

			case LN_ENTER:
				Index = (SHORT) WinSendDlgItemMsg (hwnd, IDD_DIRLIST2,
												   LM_QUERYSELECTION, 0L, 0L);

				WinSendDlgItemMsg (hwnd, IDD_DIRLIST2, LM_QUERYITEMTEXT,
								   MPFROM2SHORT (Index, sizeof (szPath)),
								   MPFROMP (szPath));

				DosChDir (szPath, 0L);
				MakePath (szPath, sizeof szPath);
				WinSetDlgItemText (hwnd, IDD_DIRECTORY2, szPath);
				FillDirListBox (hwnd, IDD_DIRLIST2);
				return (0);
			}
			break;
		}
		break;

	case WM_COMMAND:
		switch (COMMANDMSG (&msg) -> cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_NEWFILENAME,
								 sizeof (szPath), szPath);
			MakeQFN (szPath, szCurrentFile, sizeof szCurrentFile);
			WinDismissDlg (hwnd, TRUE);
			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	OpenDlgProc processes messages sent to the File Open dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY OpenDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	SHORT		Index;
	static CHAR szPath[255];
	static CHAR	szFileName[255];

	switch (msg) {

	case WM_INITDLG:
		FillDriveListBox (hwnd, IDD_DRIVELIST);
		FillDirListBox (hwnd, IDD_DIRLIST);
		FillFileListBox (hwnd, IDD_FILELIST);
		WinSendDlgItemMsg (hwnd, IDD_FILENAME, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (254, 0), NULL);
		MakePath (szPath, sizeof szPath);
		WinSetDlgItemText (hwnd, IDD_DIRECTORY, szPath);
		return (0);

	case WM_CONTROL:
		switch (SHORT1FROMMP (mp1)) {

		case IDD_DRIVELIST:
			switch (SHORT2FROMMP (mp1)) {

			case LN_ENTER:
				Index = (SHORT) WinSendDlgItemMsg (hwnd, IDD_DRIVELIST,
												   LM_QUERYSELECTION, 0L, 0L);

				WinSendDlgItemMsg (hwnd, IDD_DRIVELIST, LM_QUERYITEMTEXT,
								   MPFROM2SHORT (Index, sizeof (szPath)),
								   MPFROMP (szPath));

				DosSelectDisk ((USHORT) szPath[1] - 0x40);
				MakePath (szPath, sizeof szPath);
				WinSetDlgItemText (hwnd, IDD_DIRECTORY, szPath);
				FillDirListBox (hwnd, IDD_DIRLIST);
				FillFileListBox (hwnd, IDD_FILELIST);
				return (0);
			}
			break;

		case IDD_DIRLIST:
			switch (SHORT2FROMMP (mp1)) {

			case LN_ENTER:
				Index = (SHORT) WinSendDlgItemMsg (hwnd, IDD_DIRLIST,
												   LM_QUERYSELECTION, 0L, 0L);

				WinSendDlgItemMsg (hwnd, IDD_DIRLIST, LM_QUERYITEMTEXT,
								   MPFROM2SHORT (Index, sizeof (szPath)),
								   MPFROMP (szPath));

				DosChDir (szPath, 0L);
				MakePath (szPath, sizeof szPath);
				WinSetDlgItemText (hwnd, IDD_DIRECTORY, szPath);
				FillDirListBox (hwnd, IDD_DIRLIST);
				FillFileListBox (hwnd, IDD_FILELIST);
				return (0);
			}
			break;

		case IDD_FILELIST:
			switch (SHORT2FROMMP (mp1)) {

			case LN_SELECT:
				Index = (SHORT) WinSendDlgItemMsg (hwnd, IDD_FILELIST,
												   LM_QUERYSELECTION, 0L, 0L);

				WinSendDlgItemMsg (hwnd, IDD_FILELIST, LM_QUERYITEMTEXT,
								   MPFROM2SHORT (Index, sizeof (szFileName)),
								   MPFROMP (szFileName));

				WinSetDlgItemText (hwnd, IDD_FILENAME, szFileName);
				return (0);

			case LN_ENTER:
				MakeQFN (szFileName, szCurrentFile, sizeof szCurrentFile);
				WinDismissDlg (hwnd, TRUE);
				return (0);
			}
			break;
		}
		break;

	case WM_COMMAND:
		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_FILENAME, sizeof (szFileName),
								 szFileName);
			MakeQFN (szFileName, szCurrentFile, sizeof szCurrentFile);
			WinDismissDlg (hwnd, TRUE);
			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	ConfigDlgProc processes messages sent to the Settings dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY ConfigDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	static struct CommParms LclParms;
	static BOOL fSaveSettings = TRUE;

	switch (msg) {

	case WM_INITDLG:
		LclParms.BaudRate = GblParms.BaudRate;
		LclParms.COMPort = GblParms.COMPort;
		LclParms.Parity = GblParms.Parity;
		LclParms.DataBits = GblParms.DataBits;
		LclParms.StopBits = GblParms.StopBits;

		WinSendDlgItemMsg (hwnd, LclParms.BaudRate + IDD_BAUDRATE, BM_SETCHECK,
						   MPFROM2SHORT (TRUE, 0), NULL);
		WinSendDlgItemMsg (hwnd, LclParms.COMPort + IDD_COMPORT, BM_SETCHECK,
						   MPFROM2SHORT (TRUE, 0), NULL);
		WinSendDlgItemMsg (hwnd, LclParms.Parity + IDD_PARITY, BM_SETCHECK,
						   MPFROM2SHORT (TRUE, 0), NULL);
		WinSendDlgItemMsg (hwnd, LclParms.DataBits + IDD_DATABITS, BM_SETCHECK,
						   MPFROM2SHORT (TRUE, 0), NULL);
		WinSendDlgItemMsg (hwnd, LclParms.StopBits + IDD_STOPBITS, BM_SETCHECK,
						   MPFROM2SHORT (TRUE, 0), NULL);

		WinSendDlgItemMsg (hwnd, IDD_DIALTEXT, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (16, 0), NULL);
		WinSetDlgItemText (hwnd, IDD_DIALTEXT, szDialCmd);

		WinSendDlgItemMsg (hwnd, IDD_HANGUPTEXT, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (16, 0), NULL);
		WinSetDlgItemText (hwnd, IDD_HANGUPTEXT, szHangUpCmd);

		WinSendDlgItemMsg (hwnd, IDD_DEFDATAFILE, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (128, 0), NULL);
		WinSetDlgItemText (hwnd, IDD_DEFDATAFILE, szDefDataFile);

		WinSendDlgItemMsg (hwnd, IDD_DIALPREFIX, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (6, 0), NULL);
		WinSetDlgItemText (hwnd, IDD_DIALPREFIX, szDialPrefix);

		WinSendDlgItemMsg (hwnd, IDD_CHECKSAVE, BM_SETCHECK,
						   MPFROM2SHORT (fSaveSettings, 0), NULL);

		WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, LclParms.BaudRate + IDD_BAUDRATE));
		return (1);

	case WM_CONTROL:
		if ((SHORT1FROMMP (mp1) >= IDD_BAUDRATE) &&
			(SHORT1FROMMP (mp1) < IDD_COMPORT))
			LclParms.BaudRate = SHORT1FROMMP (mp1) - IDD_BAUDRATE;

		else if ((SHORT1FROMMP (mp1) >= IDD_COMPORT) &&
			(SHORT1FROMMP (mp1) < IDD_PARITY))
			LclParms.COMPort = SHORT1FROMMP (mp1) - IDD_COMPORT;

		else if ((SHORT1FROMMP (mp1) >= IDD_PARITY) &&
			(SHORT1FROMMP (mp1) < IDD_DATABITS))
			LclParms.Parity = SHORT1FROMMP (mp1) - IDD_PARITY;

		else if ((SHORT1FROMMP (mp1) >= IDD_DATABITS) &&
			(SHORT1FROMMP (mp1) < IDD_STOPBITS))
			LclParms.DataBits = SHORT1FROMMP (mp1) - IDD_DATABITS;

		else if ((SHORT1FROMMP (mp1) >= IDD_STOPBITS) &&
			(SHORT1FROMMP (mp1) < IDD_STOPBITS + 2))
			LclParms.StopBits = SHORT1FROMMP (mp1) - IDD_STOPBITS;

		else if (SHORT1FROMMP (mp1) == IDD_CHECKSAVE)
			fSaveSettings = fSaveSettings ? FALSE : TRUE;

		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_DIALTEXT, 40, szDialCmd);
			WinQueryDlgItemText (hwnd, IDD_HANGUPTEXT, 40, szHangUpCmd);
			WinQueryDlgItemText (hwnd, IDD_DEFDATAFILE, 128, szDefDataFile);
			WinQueryDlgItemText (hwnd, IDD_DIALPREFIX, 40, szDialPrefix);

			strupr (szDefDataFile);

			GblParms.BaudRate = LclParms.BaudRate;
			GblParms.COMPort = LclParms.COMPort;
			GblParms.Parity = LclParms.Parity;
			GblParms.DataBits = LclParms.DataBits;
			GblParms.StopBits = LclParms.StopBits;

			if (fSaveSettings) {
				WinWriteProfileData (hab, szAppName, szKeyName1,
									 &GblParms, sizeof (GblParms));
				WinWriteProfileString (hab, szAppName, szKeyName2, szDialCmd);
				WinWriteProfileString (hab, szAppName, szKeyName3, szHangUpCmd);
				WinWriteProfileString (hab, szAppName, szKeyName4, szDefDataFile);
				WinWriteProfileString (hab, szAppName, szKeyName5, szDialPrefix);
			}

			WinDismissDlg (hwnd, TRUE);
			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	StatusDlgProc processes messages sent to the Memory dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY StatusDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	CHAR	szBuffer[10];
	ULONG	ulBytesFree, ulBytesAvail, ulBytesUsed = 0;
	USHORT	i;

	switch (msg) {

	case WM_INITDLG:
		for (i=0; i<CardCount; i++)
			ulBytesUsed += (ULONG) usCardLength[i];
		ulBytesFree = 0xFFFE - ulBytesUsed;
		ulBytesAvail = 0xFFFE - (ULONG) usTopOffset;

		ultoa (ulBytesUsed, szBuffer, 10);
		WinSetDlgItemText (hwnd, IDD_BYTESUSED, szBuffer);
		ultoa (ulBytesFree, szBuffer, 10);
		WinSetDlgItemText (hwnd, IDD_BYTESFREE, szBuffer);
		ultoa (ulBytesAvail, szBuffer, 10);
		WinSetDlgItemText (hwnd, IDD_BYTESAVAIL, szBuffer);
		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG (&msg) -> cmd) {
			case DID_OK:
			case DID_CANCEL:
				WinDismissDlg (hwnd, TRUE);
				return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	GotoDlgProc processes messages sent to the Go To dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY GotoDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	CHAR	szBuffer[5];
	LONG	lNewCard;

	switch (msg) {

	case WM_INITDLG:
		WinSendDlgItemMsg (hwnd, IDD_CARDNO, EM_SETTEXTLIMIT,
						   MPFROM2SHORT (sizeof (szBuffer) - 1, 0), NULL);
		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_CARDNO, sizeof szBuffer, szBuffer);

			lNewCard = atol (szBuffer);
			if ((lNewCard > 0) && (lNewCard <= CardCount)) {
				CardNo = (SHORT) lNewCard - 1;
				WinDismissDlg (hwnd, TRUE);
			}
			else
				WinDismissDlg (hwnd, FALSE);

			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}

/*---------------------------------------------------------------------------
	DialDlgProc processes messages sent to the Dial dialog box.
---------------------------------------------------------------------------*/

MRESULT EXPENTRY DialDlgProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
	static USHORT usIndex;

	switch (msg) {

	case WM_INITDLG:
		WinSendDlgItemMsg (hwnd, IDD_PHONENO, EM_SETTEXTLIMIT,
					    MPFROM2SHORT (16, 0), NULL);

		if (usPhoneCount != 0) {
			WinSetDlgItemText (hwnd, IDD_PHONENO, szPhoneList);
			WinSendMsg (WinWindowFromID (hwnd, IDD_PHONENO),
						EM_SETSEL, MPFROM2SHORT (0, 99), 0L);
		}

		WinEnableWindow (WinWindowFromID (hwnd, DID_NEXT),
						 (usPhoneCount > 1) ? TRUE : FALSE);

		usIndex = 0;
		return (0);

	case WM_COMMAND:

		switch (COMMANDMSG(&msg)->cmd) {

		case DID_OK:
			WinQueryDlgItemText (hwnd, IDD_PHONENO, 17, szPhoneNumber);
			WinDismissDlg (hwnd, TRUE);
			return (0);

		case DID_CANCEL:
			WinDismissDlg (hwnd, FALSE);
			return (0);

		case DID_NEXT:
			usIndex = (usIndex == usPhoneCount-1) ? 0 : usIndex + 1;
			WinSetDlgItemText (hwnd, IDD_PHONENO, &szPhoneList[usIndex*20]);
			WinSendMsg (WinWindowFromID (hwnd, IDD_PHONENO),
						EM_SETSEL, MPFROM2SHORT (0, 20), 0L);
			WinSetFocus (HWND_DESKTOP, WinWindowFromID (hwnd, IDD_PHONENO));
			return (0);
		}
		break;
	}
	return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}
