//  WC.C        Count characters, words, lines, and sentences in an
//              ASCII text file.  32-bit application for OS/2 2.0 SDK.
//              Word and sentence counting logic is simplistic and
//              is intended for demonstration purposes only.
//
//  Compile:    CL386 WC.C
//
//  Usage:      WC filename.ext
//
//  Copyright (C) 1989 Ziff Davis Communications
//  PC Magazine * Ray Duncan

#include <stdio.h>

#define INCL_DOS
#include <os2.h>

#define TAB     '\x09'                      // ASCII tab character
#define LF      '\x0A'                      // ASCII line feed
#define FF      '\x0C'                      // ASCII form feed
#define CR      '\x0D'                      // ASCII carriage return
#define BLANK   '\x20'                      // ASCII blank
#define EOFMK   '\x1A'                      // ASCII end-of-file mark

main(int argc, char *argv[])
{
    HFILE fhandle;                          // receives file handle
    FILESTATUS fstatus;                     // receives file information
    PBYTE fbuffer;                          // receives buffer address
    ULONG fptr;                             // index to buffer
    ULONG faction;                          // receives DosOpen action
    ULONG frlen;                            // receives DosRead length
    ULONG fchars;                           // chars. in file
    ULONG fwords = 0;                       // words in file
    ULONG flines = 0;                       // lines in file
    ULONG fsentences = 0;                   // sentences in file
    ULONG wflag = 0;                        // TRUE if inside word

                                            // try and open file...
    if(DosOpen(argv[1],                     // filename from command line
        &fhandle,                           // receives file handle
        &faction,                           // receives DosOpen action
        0,                                  // file size (ignored)
        0,                                  // file attribute (ignored)
        FILE_OPEN,                          // fail if doesn't exist
        OPEN_ACCESS_READONLY | OPEN_SHARE_DENYWRITE,    // access mode
        NULL))                              // pointer to EAOP structure
    {
        printf("\nwc: can't open file %s", argv[1]);
        exit(1);
    }
                                            // get file size...
    if(DosQueryFileInfo(fhandle,            // file handle
        FIL_STANDARD,                       // information level 1
        (PBYTE) &fstatus,                   // address of info structure
        sizeof(fstatus)))                   // size of info structure
    {
        printf("\nwc: can't get file size");
        exit(2);
    }

    fchars = fstatus.cbFile;                // save file size

                                            // allocate memory object...
    if(DosAllocMem(&fbuffer,                // receives object offset
        fchars,                             // size to allocate
        PAG_COMMIT | PAG_READ | PAG_WRITE)) // commit backing store
    {
        printf("\nwc: can't allocate file buffer");
        exit(3);
    }
                                            // read the entire file
    DosRead(fhandle,                        // file handle
        fbuffer,                            // buffer address
        fchars,                             // length to read
        &frlen);                            // receives actual length

    DosClose(fhandle);                      // close the file   

    for(fptr = 0; fptr < fchars; fptr++)    // scan the file
    {
        switch(fbuffer[fptr])               // check this character
        {
            case '.':                       // period found, count
                fsentences++;               // sentences (simplistic
                break;                      // assumption for demo)

            case LF:                        // line feed found, count
                flines++;                   // lines, fall through

            case CR:                        // if first whitespace
            case BLANK:                     // character following
            case FF:                        // text, count words
            case TAB:
            case EOFMK:
                if(wflag) fwords++;
                wflag = FALSE;
                break;

            default:                        // if not whitespace
                wflag = TRUE;               // character, assume we
                break;                      // are traversing a word
        }
    }

    if(wflag) fwords++;                     // in case word at EOF

    DosFreeMem(fbuffer);                    // release file buffer

    printf("\n%d characters, %d words, %d lines, %d sentences.\n",
        fchars, fwords, flines, fsentences);
}
