;----------------------------------------------------;
;  TPFST-AT * PC Magazine * Michael J. Mefford       ;
;  Keyboard acceleration that takes advantage        ;
;  of the special BIOS services of the AT and PS/2.  ;
;----------------------------------------------------;

_TEXT          SEGMENT PUBLIC 'CODE'
               ASSUME  CS:_TEXT,DS:_TEXT

               ORG     100H
START:         JMP     MAIN

;              DATA AREA
;              ---------
SIGNATURE      DB      CR,SPACE,SPACE,SPACE,CR,LF

COPYRIGHT      DB      "TPFST-AT 1.0 (c) 1989 Ziff Communications Co.",CR,LF
PROGRAMMER     DB      "PC Magazine ",BOX," Michael J. Mefford",CR,LF,LF,"$"

SYNTAX         DB      "Syntax:  TPFST-AT [m,n | N]",CR,LF
               DB      "m = typematic rate (0 - 31); larger m = faster rate"
               DB      CR,LF
               DB      "n = initial delay  (0 - 3);  larger n = longer delay"
               DB      CR,LF
               DB      "N=normal: m = 20; n = 1",CR,LF
               DB      "default:  m = 27; n = 0",CR,LF,LF,"$"
               DB      CTRL_Z

BAD_PARAMETER  DB      "Invalid parameter",CR,LF,LF,BELL,"$"

CR             EQU     13
LF             EQU     10
COMMA          EQU     ","
CTRL_Z         EQU     26
SPACE          EQU     32
BOX            EQU     254
BELL           EQU     7

REPEAT_MAX     EQU     31
REPEAT_NORMAL  EQU     REPEAT_MAX - 20
REPEAT_DEFAULT EQU     27
INIT_MAX       EQU     3
INIT_NORMAL    EQU     1
INIT_DEFAULT   EQU     0

;              CODE AREA
;              ---------

MAIN           PROC    NEAR

               CLD                             ;All string operations forward.

               MOV     DX,OFFSET SIGNATURE     ;Display signature.
               CALL    PRINT_STRING

               MOV     SI,81H                  ;Point to parameters.
FIND_PARA:     LODSB
               CMP     AL,CR
               JZ      FOUND_END
               CMP     AL,SPACE
               JBE     FIND_PARA
FOUND_END:     DEC     SI

TYPEMATIC:     MOV     BL,REPEAT_NORMAL        ;Assume normal parameters.
               MOV     BH,INIT_NORMAL
               MOV     AL,BYTE PTR [SI]
               AND     AL,5FH
               CMP     AL,"N"                  ;Is it (N)ormal request?
               JZ      SET_TYPE                ;If yes, assumed right.
               CALL    DECIMAL_INPUT           ;Get requested typematic rate.
               MOV     BL,REPEAT_DEFAULT       ;Assume no parameter.
               JZ      STORE_REPEAT            ;If none, use default.
               MOV     BL,AL                   ;Else, rate in BL.
               CMP     BL,REPEAT_MAX           ;Is it greater than max rate?
               JA      ERROR_EXIT              ;If yes, exit with error.
STORE_REPEAT:  NEG     BL                      ;Inverse rate by subtracting
               ADD     BL,REPEAT_MAX           ; from maximum rate.
               CALL    DECIMAL_INPUT           ;Get requested initial delay.
               MOV     BH,INIT_DEFAULT         ;Assume no parameter.
               JZ      SET_TYPE                ;If none, use default.
               MOV     BH,AL                   ;Else, delay in BL.
               CMP     BH,INIT_MAX             ;Is it greater than max delay?
               JA      ERROR_EXIT              ;If yes, exit with error.
SET_TYPE:      MOV     AX,305H                 ;Set typematic rate and delay
               INT     16H                     ; via BIOS.
               XOR     AL,AL                   ;ErrorLevel = 0.
               JMP     SHORT EXIT              ;Done here.

ERROR_EXIT:    MOV     DX,OFFSET BAD_PARAMETER ;Display error message.
               CALL    PRINT_STRING
               MOV     AL,1                    ;ERRORLEVEL = 1.

EXIT:          PUSH    AX                      ;Preserve ERRORLEVEL.
               MOV     DX,OFFSET SYNTAX        ;Display syntax message.
               CALL    PRINT_STRING
               POP     AX                      ;Retrieve ERRORLEVEL.
               MOV     AH,4CH                  ;Terminate.
               INT     21H

MAIN           ENDP

;----------------------------------------------------------------------;
; INPUT:  SI -> string;                                                ;
; OUTPUT: SI -> end of string; AX = number; ZF = 1 if no number found. ;
;----------------------------------------------------------------------;
DECIMAL_INPUT: PUSH    BX
               XOR     BX,BX                   ;Start with zero as number.
               XOR     BP,BP                   ;Number found flag.
NEXT_DECIMAL:  LODSB                           ;Get a character.
               SUB     AL,"0"                  ;ASCII to binary.
               JC      DECIMAL_END             ;If not between 0 and 9, skip.
               CMP     AL,9
               JA      DECIMAL_END
               CBW                             ;Convert byte to word.
               XCHG    AX,BX                   ;Swap old and new number.
               MOV     CX,10                   ;Shift to left by multiplying
               MUL     CX                      ; last entry by ten.
               ADD     BX,AX                   ;Add new number and store in BX.
               INC     BP
               JMP     NEXT_DECIMAL
DECIMAL_END:   DEC     SI                      ;SI -> string end.
               MOV     AX,BX
               OR      BP,BP                   ;Number found flag.
               POP     BX
               RET

;--------------------------;

PRINT_STRING:  MOV     AH,9                    ;Print string via DOS.
               INT     21H
               RET

_TEXT          ENDS
               END     START
