;      ANSIHERE.ASM - Check to see if ANSI.SYS is loaded and display message.
;                     Exit with errorlevel = 1 if ANSI is loaded, 0 otherwise.
;                     By William Loud
;
;      SYNTAX:  ANSIHERE [S]
;          The 'S' parameter will suppress output of the status
;          message when ANSIHERE is used in batch files.
;
;   This program checks for ANSI by writing the ANSI Device Status Report
;   (DSR) sequence to the display.  If ANSI is loaded, it will output a
;   Cursor Position Report (CPR) to the standard input device (the keyboard).
;   Therefore, if you issue a DSR and find anything in the keyboard buffer,
;   you can assume it's a CPR and that ANSI is loaded.  Conversely, if the
;   keyboard buffer is empty, then ANSI is not loaded.

              TITLE     ANSIHERE

CODE_SEG      SEGMENT                        ;Define code segment
              ASSUME    cs:CODE_SEG,ds:CODE_SEG
              ORG       100h

start:        jmp       begin                ;skip over data

Identify      DB        ' ANSIHERE.COM  ',26
Errorlevel    DB        0             ;exit code, default is no ANSI
DSR_string    DB        27,'[6n$'     ;Device Status Report ANSI string
YesMsg        DB        'ANSI.SYS is loaded.$'
NoMsg         DB        13,'ANSI.SYS is NOT loaded.$'
EraseDSR      DB        13,32,32,32,32,'$'
; The carriage return at the beginning of EraseDSR returns the cursor
; to the start of the current line and the four spaces will overwrite
; the garbage left by the DSR_string if ANSI is not loaded.

begin:        mov       dx,OFFSET DSR_string  ;display the ANSI DSR_string
              call      Print_String          ; to see if ANSI is loaded

              mov       ah,0Bh             ;check for key in the keyboard
              int       21h                ; buffer - if there's anything
              cmp       al,0FFh            ; there, ANSI is loaded
              je        clear_key          ;go empty the buffer

; Keyboard buffer is empty so ANSI is not loaded.
              mov       dx,OFFSET EraseDSR ;erase the garbage left by the
              call      Print_String       ; DSR_String
              mov       dx,OFFSET NoMsg    ;point to 'not loaded' message
              jmp       parse              ; and check command line arguments

; ANSI is loaded.  We must empty the keyboard buffer because it contains
; a Cursor Position Report which DOS will attempt to execute when this
; program terminates.
clear_key:    mov       ah,06h             ;get key from the keyboard buffer
              mov       dl,0FFh            ; don't wait if the buffer is empty
              int       21h                ; and don't print it to the screen
              jnz       clear_key          ;go back for more until buffer is
                                           ; empty and zero flag is set

              mov       dx,OFFSET YesMsg   ;point to 'ANSI is loaded' message
              mov       Errorlevel,01h     ;set errorlevel = 1

; Check for command line arguments.  If 'S' was entered on the command line
; we won't display the status message.  When ANSIHERE is used in batch files
; we'll want to suppress the status message and use errorlevel tests to
; control program flow.

parse:        mov       bx,0080h           ;point to command line in PSP
parse_loop:   inc       bx                 ;point to next character
              cmp       Byte Ptr [bx],13   ;is it a carriage return?
              je        printMsg           ;done - print status message
              and       Byte Ptr [bx],5Fh  ;convert to uppercase
              cmp       Byte Ptr [bx],'S'  ;is it 'S' ?
              jnz       parse_loop         ;no - get another character
              jmp       exit               ;yes - skip status message

printMsg:     call      Print_String       ;print status message
exit:         mov       ah,4Ch             ;DOS exit function in ah
              mov       al,Errorlevel      ; errorlevel in al
              int       21h

;--------------------- Print_String subroutine -----------------------------
Print_String: mov       ah,09h            ;print string function
              int       21h
              ret

CODE_SEG      ENDS
              END       start
