PROGRAM DefaultDemo;
(*by Knut Fogelqvist, Molndal, Sweden.*)

VAR
  Length, Width, Height, Volume : Real;
  UnitString                    : STRING;

  FUNCTION RealIn(Default : Real) : Real;
  (*Input Real number, return Default if
    user just pressed Enter.  Can easily
    be modified to use a different numeric
    type, e.g. Extended, Double etc*)
  VAR
    NewIn : STRING;
    Stat  : Integer;
    Temp  : Real;
  BEGIN
    REPEAT
      Temp := Default;
      Stat := 0;
      ReadLn(NewIn);
      IF NewIn <> '' THEN
        Val(NewIn, Temp, Stat);
      IF Stat <> 0 THEN
        BEGIN
          Write(#7, 'Erroneous input, character no ');
          Write( Stat:2, ', write again! ');
        END;
    UNTIL Stat = 0;
    RealIn := Temp;
  END;

  FUNCTION StringIn(Default : STRING) : STRING;
  (*Input a string, return Default if user
    just pressed Enter*)
  VAR NewIn, Temp : STRING;
  BEGIN
    Temp := Default;
    ReadLn(NewIn);
    IF NewIn = '' THEN
      StringIn := Temp
    ELSE
      StringIn := NewIn;
  END;

BEGIN
(* Here initial default values are assigned to
   the variables used in the example, which just
   computes the volume of a box.*)
  Length := 108.0116441;
  Width := 51.02108781;
  Height := 9.072974990;
  UnitString := 'centimeter';
  REPEAT
    Write('Length of box = ', Length:15:5, ' ');
    Write(UnitString, '. New length = ');
    Length := RealIn(Length);

    Write('Width of box  = ', Width:15:5, ' ');
    Write(UnitString, '. New width  = ');
    Width := RealIn(Width);

    Write('Height of box = ', Height:15:5, ' ');
    Write(UnitString, '. New height = ');
    Height := RealIn(Height);
    Volume := Length*Width*Height;
    WriteLn;
    Write('The Volume is = ', Volume:15:5);
    WriteLn(' cubic ', UnitString, 's');
    WriteLn;

    Write('Unit = ', UnitString, ' (end this ');
    Write('program with "end"). New unit = ');
    UnitString := StringIn(UnitString);
    WriteLn;
  UNTIL UnitString = 'end';
END.
