/* timerun.c RHS 5/18/88
 *
 * This program times the load and execution time of another program.
 *
 * Return Values set are:
 *   The return value of the 'child' program, or
 *   255 if unsucessful.
 *
 * For MSC 5.x:
 *        cl /Ox /W3 timerun.c
 */
 
#include<time.h>
#include<process.h>
#include<stdio.h>
 
void main(int argc, char **argv);
 
void main(int argc, char **argv)
{
     long start = 0L, end = 0L;
     int retval;
 
     if(argc < 2)
     {
          printf("\nUsage: timerun <program> [args...]");
          printf("\nPurpose: to report the run time of a program in seconds");
          exit(255);
     }
 
     printf("\ntimerun: attempting to run: %s...",argv[1]);
 
     argv++;                       /* set argv to point to argv[1]    */
                                   /* the old argv[1] is now argv[0]  */
 
     start = clock();              /* start the clock ...             */
 
                                   /* run the child                   */
     if((retval = spawnvp(P_WAIT,argv[0],argv)) == -1)
     {
          printf("\ntimerun: Child process failed, aborting...");
          exit(255);
     }
 
     end = clock();                /* get clock after return from child*/
 
     printf("\ntimerun: \"%s\" took %04.02f seconds to load and execute",
          argv[0],(float)(end-start)/CLK_TCK);
 
     exit(retval);                 /* exit with return value of child */
}
