/*
    TRYSTD.C:   Demo of time and date conversion
                routines in SCANTD.C and TD.C.

    By Ray Duncan, February 1988

    Compile:    C>CL TRYSTD.C TD.C SCANTD.C <Enter>

*/

#include <stdio.h>

                                    /* prototypes for TD.C */   

extern char * tcvt(int, int, int, int, int);
extern char * dcvt(int, int, int, int);

                                    /* prototypes for SCANTD.C */

extern int scantime(char *, int *, int *, int *);
extern int scandate(char *, int *, int *, int *);

main()
{   
    char buffer[80];                /* used for keyboard input */

    int month,day,year;             /* binary date from scandate */
    int hour,min,sec;               /* binary time from scantime */

    int status;                     /* flag from scantime or scandate */
                                    /* <>0 if valid date or time */

    while(1)

    {   printf("\n\nEnter date: "); /* prompt user for date */

        gets(buffer);               /* input date */    

        if(buffer[0]==0) exit(0);   /* if no entry, exit */

                                    /* convert ASCII date to 
                                       binary month, day, year */

        status = scandate(buffer,&month,&day,&year);

                                    /* if valid, convert back
                                       to ASCII and display */

        if(status) printf("You entered: %s", dcvt(8,month,day,year));

        else printf("Bad date!");   /* otherwise error message */

        printf("\n\nEnter time: "); /* prompt user for time */

        gets(buffer);               /* input time */

        if(buffer[0]==0) exit(0);   /* if no entry, exit */

                                    /* convert ASCII time to 
                                       binary hours, min, sec */

        status = scantime(buffer,&hour,&min,&sec);

                                    /* if valid, convert back
                                       to ASCII and display */

        if(status) printf("You entered: %s", tcvt(8,hour,min,sec,0));

        else printf("Bad time!");   /* otherwise error message */

    }
}


