; RHCTRL.ASM - TSR to map number pad 5 as CTRL key -- by Johnny Y. Chin

CODE	SEGMENT
	ASSUME CS:CODE,DS:CODE
        ORG	100H

START:	JMP	INITIALIZE
;========================================================================
;	DATA AREA

MARK	DB	'Y'		;residency marker 
OLDKEY	DD	?
CTRL	DB	0
;========================================================================
;	KEYBOARD INTERCEPTOR

NEWKEY:	PUSHF			;save registers                   
	PUSH	AX                                                
        PUSH	DS                                                
                                                                  
	MOV	AX,40H		;point to BIOS data               
        MOV	DS,AX                                             
        MOV	AH,DS:[17H]	;save keyboard flag               
	IN	AL,60H		;get keystroke scan code          
                                                                  
	CMP	AL,4CH		;numeric pad-5 pressed?           
        JNZ	RELEASE		;if not check release             
        TEST	AH,00001000B	;check alternate key pressed?     
        JNZ	NO_BUSINESS                                       
                                                                  
        CMP	CS:CTRL,1	;if yes, it is a typematic repeat?
        JZ	RESET		;if yes, ignore                  
        OR	AH,00000100B	;else, turn on Ctrl flag bit      
        MOV	CS:CTRL,1                                         
        JMP	SHORT STORE	;store and exit                   

RELEASE:
	CMP	AL,4CH+10000000B	;is it real pad-5 release?
        JNZ	NO_BUSINESS	;if not, pass on to int 09h  
        TEST	AH,00001000B	;check alternate key pressed?
        JNZ	NO_BUSINESS                                  
                                                             
	AND	AH,11111011B	;else, turn off Ctrl flag bit
        MOV	CS:CTRL,0                                    
STORE:	MOV	DS:[17H],AH	;store new keyboard flag
                                                             
RESET:	IN	AL,61H		;get keyboard status         
	MOV	AH,AL		;save status                 
        OR	AL,80H		;clear signal                
        OUT	61H,AL		;send to keyboard            
        XCHG	AH,AL		;get original status         
        OUT	61H,AL

	CLI
        MOV	AL,20H
        OUT	20H,AL

	POP	DS
        POP	AX
        POPF
        IRET

NO_BUSINESS:
	POP	DS
        POP	AX
        POPF
        JMP	CS:OLDKEY

;========================================================================
HX2AS	PROC	NEAR
; Convert Hex Value in AL to ASCII and return in AX
	PUSH	CX
        MOV	AH,AL		;save input
        MOV	CL,4		;get high nibble
        SHR	AL,CL
        CMP	AL,09H
        JA      LTRH
        ADD	AL,30H
        JMP	SHORT LOWN
LTRH:	ADD	AL,37H

LOWN:   AND	AH,0FH		;get low nibble
	CMP	AH,09H
        JA	LTRL
        ADD	AH,30H
        JMP	SHORT FINI
LTRL:	ADD	AH,37H

FINI:	POP	CX
	RET
HX2AS	ENDP
;========================================================================
INITIALIZE:
	JMP	BEGIN

BANNER	DB	0AH,0DH
	DB	'Numeric pad-5 is now right-hand Ctrl key',0AH,0DH
        DB	'RHCTRL Ver 1.0 -- By Johnny Y. Chin  ',0AH,0DH
        DB	'$'

RESMSG	DB	0AH,0DH
	DB	'RHCTRL is already resident at '
SEGADD	DB	'????',0AH,0DH
        DB	'$'

BEGIN:	MOV	AX,CS
	MOV	DS,AX

	MOV	AX,3509H	;get keyboard interrupt
        INT	21H
        MOV	WORD PTR OLDKEY,BX
        MOV	WORD PTR OLDKEY[2],ES

	MOV	AL,ES:[103H]	;check residency
        CMP	AL,MARK
        JZ	RESD

	MOV	DX,OFFSET NEWKEY
        MOV	AX,2509H
        INT	21H

	MOV	AH,09H
        LEA	DX,BANNER
        INT	21H

	MOV	DX,OFFSET INITIALIZE
        INT	27H

RESD:	MOV	AX,ES
	CALL	HX2AS
        MOV	WORD PTR SEGADD+2,AX
        MOV	AX,ES
        XCHG	AH,AL
        CALL	HX2AS
        MOV	WORD PTR SEGADD,AX
	LEA	DX,RESMSG
	MOV	AH,09H
        INT	21H
        INT	20H

CODE	ENDS
	END	START
