TITLE	'MEM512 - limit memory size to 512K

;  This program will limit the amount of RAM known to the operating system
;  to 512K bytes.
;
;     If more than 512K is installed in the system, the memory size variable
;     is set to 512(K) and the system is rebooted without ROM diagnostics 
;     or memory re-sizing.
;
;     If the amount of RAM installed is less than or equal to 512K bytes,
;     a message is displayed informing the user of the amount of RAM in the
;     system.  No further action is taken.

MEMSIZE	EQU	512			;Limit of memory size (in K)

;
;  Macro to print a string of text end by '$'
;
PRINT	MACRO	STRING
	MOV	DX,OFFSET STRING
	MOV	AH,9
	INT	21H
	ENDM

;
;  Macro to delay so user can read message on screen
;
DELAY	 MACRO
	 LOCAL	DELAY_1,DELAY_2
	 MOV	AL,5
DELAY_1: MOV	CX,0FFFFh
DELAY_2: LOOP	DELAY_2
	 DEC	AL
	 JNZ	DELAY_1
	 ENDM

;
;  Code segment starts here
;
CSEG	SEGMENT
	ORG	100H
	ASSUME	CS:CSEG,DS:CSEG

INIT:	PRINT	STRTMSG			;Display the "start" message

	MOV	BX,40H			;DS:BX <= ptr to mem size variable
	MOV	DS,BX
	MOV	BX,13H
	MOV	AX,WORD PTR [BX]	;AX <= memory size value
	CMP	AX,MEMSIZE
	JBE	MEM_OK			;Jump if memory size LE 512K

;
;  Memory size is greater than 512K - set the memory size variable to 512(K)
;    and reboot the system without re-sizing memory
;
	MOV	WORD PTR [BX],MEMSIZE	;Set memory size to 512K
	PUSH	CS			;Restore DS to "CSEG"
	POP	DS
	PRINT	REBTMSG			;Tell user we're rebooting
	DELAY
	INT	19H			;Read bootstrap from disk; pass control

;
;  Memory size is less than or equal to 512K - tell user the current amount
;    of memory and take no further action.
;
MEM_OK:	PUSH	CS			;Restore DS to "CSEG"
	POP	DS

;  Move ASCII value of mem size to output string.  Mem size is in AX.

	DIV	BYTE_10
	OR	AH,30H
	MOV	KBYTES[2],AH
	AAM
	OR	AX,3030H
	XCHG	AH,AL
	MOV	WORD PTR KBYTES,AX
	PRINT	SIZEMSG			;Display the message

	INT	20H			;Exit to DOS

;------------------------------------------------------------------------------

REBTMSG	DB	'Rebooting to set memory size to 512K',13,10,'$'
SIZEMSG	DB	'System memory size is currently '
KBYTES	DB	3 dup ('0'),'K',13,10,'$'
STRTMSG DB	10,13,'MEM-512 tricks DOS into thinking '
	DB	'system has 512K or less of RAM.',13,10,'$'

BYTE_10	DB	10			;Used by Divide instruction in MEM_OK

CSEG	ENDS
	END INIT
