CONST
  ES_Override    = $2690; {ES Override of instruction}
  LES_DI__BPdisp = $BEC4; {load addr on stack into ES:DI}
  MOV_AX__BPdisp = $868B; {move integer on stack to AX}
  ADD__DI_AX     = $0501; {add AX to [DI] }
  SUB__DI_AX     = $0529; {subtract AX from [DI] }
  INC__DI        = $05FF; {increment [DI] }
  DEC__DI        = $0DFF; {decrement [DI] }

  PROCEDURE ptr_incr(VAR Pntr);
  (* increment a pointer *)
  BEGIN
    INLINE(LES_DI__BPdisp/Pntr); {load addr of variable in ES:DI}
    INLINE(ES_Override/INC__DI); {increment variable ES:[DI] }
  END;

  PROCEDURE ptr_add(VAR Pntr; bytes : Integer);
  (* add a number of bytes to a pointer *)
  BEGIN
    INLINE(LES_DI__BPdisp/Pntr);   {load addr of variable in ES:DI}
    INLINE(MOV_AX__BPdisp/bytes);  {mov length to AX}
    INLINE(ES_Override/ADD__DI_AX);{add AX to ES:[DI] }
  END;

  PROCEDURE ptr_decr(VAR Pntr);
  (* decrement a pointer *)
  BEGIN
    INLINE(LES_DI__BPdisp/Pntr); {load addr of variable in ES:DI}
    INLINE(ES_Override/DEC__DI); {increment variable ES:[DI] }
  END;

  PROCEDURE ptr_sub(VAR Pntr; bytes : Integer);
  (* subtract a number of bytes from a pointer *)
  BEGIN
    INLINE(LES_DI__BPdisp/Pntr);   {load addr of variable in ES:DI}
    INLINE(MOV_AX__BPdisp/bytes);  {mov length to AX}
    INLINE(ES_Override/SUB__DI_AX);{subtract AX from ES:[DI] }
  END;
