

'-----------------------------------------------------------------------------
' File Name: SUBPROG2.BAS
' Routines : Hercules.there

' Written  : 07/25/87 by Mark Novisoff
' Changes  : none

' Comments : none

'-----------------------------------------------------------------------------
Sub Hercules.there (Hercules.status%) Static

' Description - Determines if a Hercules card is in the system

' After calling this routine, Hercules.status% is 0 (no adapter present)
' or 1 (adapter is present).
	
	Hercules.status%=0		' set the variable to 0

	Status.port%=&h3ba		' the Hercules status port
	Old.status%=INP(Status.port%)	' get the current status
	Old.status%=Old.status% AND &h80 ' isolate bit 7 for comparison

	For N%=1 to 6400		' should be enough tests
	  Now.status%=INP(Status.port%)	' get the current status
	  Now.status%=Now.status% AND &h80 ' isolate bit 7 for comparison
	  IF Now.status%<>Old.status% then ' If the status changes
	    N%=6400			' then it probably is a Hercules card
	  End if			' so end the loop
	  				' Note that in QB 3.0, you can say
					' "Exit for" instead of N%=6400
	Next  
		
	IF Now.status%=Old.status% THEN ' If it cannot be a hercules
	  Exit Sub			' then return to main program
	End If

Try.change.memory:			' If we can change a word in memory
					' and read back the same value, then
					' there must be 32K of memory and
					' a Herc (or compatible) is present
					
	Def Seg=&hb000			' Point to monochrome memory
	Low.byte%=Peek(&h7ffe)		' Least significant byte is saved
	High.byte%=Peek(&h7fff)		'  and most significant byte					

	Poke &h7ffe,&haa		' Our signature is &h55aa
	Poke &h7fff,&h55		
	
	If Peek(&h7ffe)=&haa and Peek(&h7fff)=&h55 then
	  Hercules.status%=1		' if the change "took", then Herc is there
	  Goto Replace.bytes		' and we are finished.
	End If
	
' This is a second test in case the memory test above failed because the
' Hercules adapter was in 'diagnostic' mode.

	Config.port%=&h03bf		' the Hercules configuration port
	Out Config.port%,1		' Allow graphics only on page 0

					' Now try to change it again
					
	Poke &h7ffe,&haa		' Our signature is &h55aa
	Poke &h7fff,&h55		
	
	If Peek(&h7ffe)=&haa and Peek(&h7fff)=&h55 then
	  Hercules.status%=1		' if the change "took", then Herc is there
	End If
	
Replace.bytes:

	Poke &h7ffe,Low.byte%		' put it back the way it was
	Poke &H7fff,High.byte%		' ditto
	Def Seg				' BACK TO basic'S DEFAULT SEGMENT
		
End Sub

