
'-----------------------------------------------------------------------------
' File Name: SUBPROG1.BAS
' Routines : Find.monitor

' Written  : 07/25/87 by Mark Novisoff
' Changes  : 07/29/87 by Mark Novisoff - added code to detect VGA

' Comments : Requires EGAINFO.OBJ (source is EGAINFO.ASM)

'-----------------------------------------------------------------------------
Sub Find.monitor (Monitor.segment%,Egamode%,Egacolumns%,Egarows%,Egastatus%,Egamem%) Static

' Description - Determines if a monochrome or CGA adapter is active and
' if an EGA or VGA monitor is in the system.
' After calling this routine, check Egastatus% to determine if an EGA is
' present in the system. If so, the other variables are set as described
' below.

' The following variables are available to the main program:

' Monitor.segment% is &hb000 for monochrome or &hb800 for color.
' Egamode% is the current video mode
' Egacolumns% is the number of columns displayed on the screen (text modes)
' Egarows% is the number of rows displayed on the screen (text modes)
' Egastatus%: If -1, no EGA or VGA is present
'             If  1, EGA is in monochrome mode
'             If  0, EGA is in color mode
'             If a VGA is present, 10 is added to Egastatus% of 0 and 1
' Egamem% is the amount of memory on the EGA adapter (in Kbytes)
'-----------------------------------------------------------------------
' First we'll look at the BIOS equipment flag to determine if a CGA or
' monochrome adapter is active.

	Def Seg=&H40			' BIOS data area
	If (Peek(&H10) and &H30)=&h30 then
          Monitor.segment%=&hb000
	else
	  Monitor.segment%=&hb800
	End if
	Def Seg				' back to BASIC's default segment    	

'-----------------------------------------------------------------------

' Call our assembly language subroutine - requires EGAINFO.OBJ

	Call Egainfo(Egamode%,Egacolumns%,Egarows%,Egastatus%,Egamem%)

End Sub

