program Profiler ;

{.L-}
{$I declare.prf}
{$I environ.prf}
{$I screen.prf}
{$I profile.prf}
{$I invoke.prf}
{$I drawhist.prf}
{.L+}

var
  ch : char ;

begin
  SetupScreen ;
  DrawWarningScreen ;
  Read( KBD, ch ) ;
  if ((ch <> 'y') and (ch <> 'Y')) then
  begin
    ClrScr;
    Halt;
  end;
  DrawProfileScreen ;
  Init_Profiler ;              { Install the profiler }
  TopOfStack := StackPointer;  { Needed by invoke }
  Invoke( Command ) ;          { Execute the program to be profiled }
  Fastwrite( 'Press any key to continue.', 25, 1, TextAttr ) ;
  Read( KBD, ch );
  Remove_Int ;                 { Remove the profiler }
  ShowProfile ;                { Display data }
  ClrScr ;                     { Restore the screen }
end.

