;              Status.asm
 
CODE SEGMENT                           ;*************************
ASSUME CS:CODE,DS:CODE                 ;*                       *
ORG 100H                               ;*  REMEMBER TO EXE2BIN  *
                                       ;*                       *
                                       ;*************************
START:         JMP    BEGINNING
 
;              DATA AREA
;              ---------
COPYRIGHT      DB  'Copyright 1987 Ziff-Davis Publishing Co.',1AH
PROGRAMMER     DB  'Michael J. Mefford'
 
SWITCH1        DB  179,' O 1 2 3 4 5 6 7 8 ',179,'$'
SWITCH2        DB  '1 ',179,' N $'
SWITCH3        DB  '0 ',179,32,24,32,'$'
 
SWITCH_FLAG    DB  0
DISPLAY_FLAG   DB  0
 
;------------------------------------------------------------;
; Clear the screen by changing to 80X25 color.  Start with   ;
; graphic display of the switches. Print switch explanation. ;
;------------------------------------------------------------;
 
BEGINNING:     MOV    AH,8                   ;Get attribute at cursor.
               XOR    BH,BH                  ;Page zero.
               INT    10H
               MOV    BH,AH
               XOR    CX,CX
               MOV    DX,184FH               ;Entire screen.
               MOV    AX,600H                ;Scroll active page.
               INT    10H
 
               MOV    BP,16H                 ;BP will be used for cursor
               MOV    DX,OFFSET HEADING      ; position. Display heading
               CALL   LOCATE_STRING          ; at row 0, col 22 (16H).
 
               MOV    BP,123H                ;Row 1, col 35.
               MOV    DX,OFFSET SWITCHES     ;Print "Switches".
               CALL   LOCATE_STRING
 
               MOV    BP,21DH                ;Row 2, col 29.
               CALL   LOCATE
               MOV    DL,218                 ;Display switch box starting
               CALL   PRINT_CHAR             ; with upper left corner.
               CALL   PRINT_LINE             ;Print the line.
               MOV    DL,191                 ;Upper right corner.
               CALL   PRINT_CHAR
 
               MOV    BP,31DH                ;Row 3, col 29.
               MOV    DX,OFFSET SWITCH1      ;More of switch display.
               CALL   LOCATE_STRING
 
               MOV    BP,41BH                ;Row 4, col 27.
               MOV    DX,OFFSET SWITCH2      ;More of switch display.
               CALL   LOCATE_STRING
 
               MOV    BX,20DBH               ;Space = 0  block = 1.
               JMP    SHORT ON               ;Display on position first.
 
OFF:           MOV    DL,179                 ;Finish box on line 4.
               CALL   PRINT_CHAR
               MOV    BP,51BH                ;Row 5, col 27.
               MOV    DX,OFFSET SWITCH3      ;More of switch display.
               CALL   LOCATE_STRING
               MOV    BX,0DB20H              ;Switch graphic characters.
 
ON:            MOV    CX,8                   ;Display all 8 switch settings.
               INT    11H                    ;Equipment determination.
               MOV    DH,AL                  ;Save in DH.
NEXT_SWITCH:   MOV    DL,BH                  ;Assume one of the char.
               TEST   DH,1                   ;Is bit on?
               JZ     GOT_IT                 ;If yes, display graphic char.
               MOV    DL,BL                  ;Else, get other char.
GOT_IT:        CALL   PRINT_CHAR             ;Print the char.
               MOV    DL,32                  ;Space between settings.
               CALL   PRINT_CHAR
               ROR    DH,1                   ;Rotate one to get next bit.
               LOOP   NEXT_SWITCH            ;Get next bit.
               INC    SWITCH_FLAG            ;Now check for off bit settings.
               CMP    SWITCH_FLAG,2          ;Have we done it already?
               JNZ    OFF                    ;If no, do it now.
 
               MOV    DL,179                 ;Finish line 5.
               CALL   PRINT_CHAR
               MOV    BP,61DH                ;Row 6, col 29.
               CALL   LOCATE
               MOV    DL,192                 ;Bottom left of box.
               CALL   PRINT_CHAR
               CALL   PRINT_LINE             ;Display the line.
               MOV    DL,217                 ;Finish with bottom right.
               CALL   PRINT_CHAR
 
               MOV    DX,OFFSET TEXT
               CALL   PRINT_STRING
 
;------------------------------------------------;
; Mark with asterisk the correct switch setting. ;
;------------------------------------------------;
 
               INT    11H                    ;Equipment determination.
               MOV    BX,AX                  ;AX will be used so store in BX.
               MOV    BP,802H                ;Assume row 8, col 2.
               MOV    DL,'*'                 ;Mark with asterisk.
               TEST   BX,1                   ;Is bit one off?
               JZ     DISPLAY_BIT1           ;If yes, we assumed right.
               ADD    BP,100H                ;Else, goto row 9.
DISPLAY_BIT1:  CALL   LOCATE_CHAR
 
               MOV    BP,0B02H               ;Assume row 11, col 2.
               TEST   BX,2                   ;Is bit two off?
               JZ     DISPLAY_BIT2           ;If yes, we assumed right.
               ADD    BP,100H                ;Else, goto row 12.
DISPLAY_BIT2:  CALL   LOCATE_CHAR
 
               MOV    BP,1202H               ;Row 18, col 2.
               CALL   BITS                   ;Mark the other bits.
 
               MOV    BP,0B27H               ;Row 11, col 39.
               CALL   BITS
 
;------------------------------------;
; Pause and check if EGA is present. ;
;------------------------------------;
 
               MOV    AX,0C000H              ;EGA BIOS segment.
               MOV    DS,AX
               MOV    SI,1EH                 ;IBM signature offset.
               MOV    DI,OFFSET IBM
               MOV    DX,OFFSET EGA          ;Assume EGA present.
               MOV    CX,3
               REPZ   CMPSB                  ;Compare three bytes.
               PUSH   CS
               POP    DS
               JNZ    FINISH_BITS            ;If not present, skip.
               ADD    BP,19                  ;Else, add 19 to column.
               CALL   LOCATE_STRING          ;And display "EGA".
 
FINISH_BITS:   MOV    BP,1027H               ;Row 16, col 39.
               CALL   BITS
 
;---------------------------------------;
; Display the number of parallel ports. ;
;---------------------------------------;
 
PRINTERS:      MOV    BP,1401H               ;Row 20, col 1.
               CALL   LOCATE
               INT    11H                    ;Get equipment again.
               MOV    DL,'0'                 ;Assume zero printers.
               TEST   AH,10000000B           ;Is bit 15 on?
               JZ     CH_PRN1                ;If no, check bit 14.
               ADD    DL,2                   ;Else, add two to count.
CH_PRN1:       TEST   AH,1000000B            ;Is bit 14 on?
               JZ     PRINT_PRN              ;If no, ready to print.
               INC    DL                     ;Else, add one to count.
PRINT_PRN:     CALL   PRINT_CHAR             ;Print the count.
               MOV    DX,OFFSET PARALLEL     ;Add the text.
               CALL   PRINT_STRING
 
;-------------------------------------;
; Display the number of serial ports. ;
;-------------------------------------;
 
SERIAL_PORT:   MOV    BP,1501H               ;Row 21, col 1.
               CALL   LOCATE
               INT    11H                    ;Retrieve equiment again.
               MOV    DL,'0'                 ;Assume zero.
               TEST   AH,100B                ;Is bit 10 on?
               JZ     CK_COM1                ;If no, check bit 9.
               ADD    DL,2                   ;Else, add two to count.
CK_COM1:       TEST   AH,10B                 ;Is bit 9 on?
               JZ     PRINT_COM              ;If no, ready to print.
               INC    DL                     ;Else, add one to count.
PRINT_COM:     CALL   PRINT_CHAR             ;Print the count.
               MOV    DX,OFFSET SERIAL       ;Add the text.
               CALL   PRINT_STRING
 
;-----------------------------------;
; Display if game port is on board. ;
;-----------------------------------;
 
GAME:          MOV    BP,1601H               ;Row 22, col 1.
               CALL   LOCATE
               INT    11H                    ;Retrieve equipment.
               MOV    DL,'0'                 ;Assume zero.
               TEST   AH,10000B              ;Is bit 12 on?
               JZ     PRN_GAME               ;If no, ready to print.
               INC    DL                     ;Else, add one to count.
PRN_GAME:      CALL   PRINT_CHAR             ;Print the count.
               MOV    DX,OFFSET GAMEPORT     ;Add the text.
               CALL   PRINT_STRING
 
;------------------------------;
; Display total system memory. ;
;------------------------------;
 
TOTAL_MEMORY:  MOV    BP,1226H                  ;Row 18, col 38.
               MOV    DX,OFFSET SYSTEM_MEMORY   ;Display text.
               CALL   LOCATE_STRING
               INT    12H                    ;Retrieve total memory.
               CALL   NO_CARRY               ;Display via division routine.
               MOV    DL,'K'                 ;Add "K".
               CALL   PRINT_CHAR
 
;--------------------------------------;
; Display the bytes free for programs. ;
;--------------------------------------;
 
BYTES_FREE:    MOV    BP,1326H               ;Row 19, col 38.
               MOV    DX,OFFSET FREE         ;Display the text.
               CALL   LOCATE_STRING
               CALL   MEMORY                 ;Get free memory.
               MOV    DL,'K'                 ;Add "K".
               CALL   PRINT_CHAR
 
;--------------------------;
; Display extended memory. ;
;--------------------------;
 
               MOV    BP,1426H               ;Row 20, col 38.
               MOV    DX,OFFSET EXTENDED
               CALL   LOCATE_STRING
               PUSH   DS                     ;Save data segment.
               MOV    AX,0F000H
               MOV    DS,AX
               MOV    AL,DS:[0FFFEH]         ;Retrieve ID byte.
               POP    DS
               CMP    AL,0FCH                ;Is it AT class machine?
               JNZ    NO_EXTEND              ;If no, no extended memory.
               MOV    AH,88H                 ;Get no. of 1K blocks
               INT    15H                    ; of extended memory.
               STI
               CMP    AX,0
               JZ     NO_EXTEND
               CALL   NO_CARRY               ;Else, display K bytes.
               MOV    DL,'K'                 ;Add the "K".
               CALL   PRINT_CHAR
               JMP    SHORT DISP_EXPAND
 
NO_EXTEND:     MOV    DX,OFFSET NONE         ;If no extended memory,
               CALL   PRINT_STRING           ; display "None".
 
;--------------------------;
; Display expanded memory. ;
;--------------------------;
 
DISP_EXPAND:   MOV    BP,1526H               ;row 21, col 38.
               MOV    DX,OFFSET EXPANDED
               CALL   LOCATE_STRING
               MOV    AX,3567H               ;Get INT 67H vector.
               INT    21H
               MOV    SI,OFFSET EMM          ;Point to "EMM".
               MOV    DI,0AH                 ;Point to Device name.
               MOV    CX,3                   ;Compare three characters.
               REPZ   CMPSB
               PUSH   CS                     ;Restore ES.
               POP    ES
               JNZ    NO_EXPAND              ;If name not there, no expanded.
               MOV    AH,42H                 ;Else, get number of 16K blocks.
               INT    67H
               MOV    AX,16                  ;Multiply by 16 to get 1K blocks.
               MUL    DX
               CALL   NO_CARRY               ;Display via division routine.
               MOV    DL,'K'                 ;Add the "K".
               CALL   PRINT_CHAR
               JMP    SHORT DOS_VERSION
 
NO_EXPAND:     MOV    DX,OFFSET NONE         ;If no expanded memory,
               CALL   PRINT_STRING           ; display "None".
 
;----------------------;
; Display DOS version. ;
;----------------------;
 
DOS_VERSION:   MOV    BP,1626H               ;Row 22, col 38.
               MOV    DX,OFFSET DOS
               CALL   LOCATE_STRING
               MOV    AH,30H                 ;Get DOS version.
               INT    21H
               MOV    BL,AH                  ;Save minor version no. in BL.
               XOR    BH,BH                  ;Zero in high half.
               MOV    DL,AL                  ;Convert major version number
               ADD    DL,30H                 ; to ASCII
               CALL   PRINT_CHAR             ; and print.
               MOV    DL,'.'                 ;Print the decimal.
               CALL   PRINT_CHAR
               CALL   TENS                   ;Display the minor number.
 
;------------------------------------------------;
; Display BIOS version and search for copyright. ;
;------------------------------------------------;
 
BIOS_VERSION:  MOV    BP,1726H               ;Row 23, col 38.
               MOV    DX,OFFSET BIOS
               CALL   LOCATE_STRING
               MOV    AX,0F000H              ;Point to ROM segment.
               MOV    DS,AX
               MOV    SI,0FFF5H              ;Point to Date
               MOV    CX,8                   ;Eight characters max.
               CALL   ASCII                  ; and display.
 
               MOV    BP,1826H               ;Row 24, col 38.
               CALL   LOCATE
 
               MOV    DX,OFFSET COPYR        ;Point to "Copyright"
               MOV    BP,9                   ;Nine characters.
               CALL   SEARCH                 ;Search.
               JNC    DISPLAY_MATCH          ;If no carry, got match.
 
               MOV    DX,OFFSET CAP_COPR     ;Point to "COPR."
               MOV    BP,5
               CALL   SEARCH                 ;And search.
               JNC    DISPLAY_MATCH
 
               MOV    DX,OFFSET LOWER_COPR   ;Point to "Copr."
               MOV    BP,5
               CALL   SEARCH                 ;And search.
               JNC    DISPLAY_MATCH
 
               MOV    DX,OFFSET CAP_C        ;Point to "(C)"
               MOV    BP,3
               CALL   SEARCH                 ;And search.
               JNC    DISPLAY_MATCH
 
               MOV    DX,OFFSET LOWER_C      ;Point to "(c)"
               MOV    BP,3
               CALL   SEARCH                 ;And search.
               JC     EXIT                   ;If didn't find it, give up.
 
DISPLAY_MATCH: PUSH   DS                     ;Save Copyright segment.
               PUSH   CS
               POP    DS
               MOV    DX,OFFSET CAP_C        ;Print (C).
               CALL   PRINT_STRING
               POP    DS                     ;Restore Copyright segment.
               MOV    CX,38                  ;Maximum of 38 characters
               CALL   ASCII                  ; and display.
 
;-------------------------------------------------------------------;
; Move the cursor to row 23 so our display won't scroll, then exit. ;
;-------------------------------------------------------------------;
 
EXIT:          MOV    BP,1700H               ;Row 23, col 0.
               CALL   LOCATE
               INT    20H                    ;Terminate.
 
;      ******* SUBROUTINES *******
 
;---------------------------------------------------------;
; This subroutine searches through ROM for the copyright. ;
;---------------------------------------------------------;
 
SEARCH:        MOV    BX,0                   ;Start at offset zero.
NEXT_SEARCH:   MOV    CX,BP                  ;Number of characters to match.
               MOV    SI,BX                  ;Retrieve starting offset.
               MOV    DI,DX                  ;DX has offset of text to match.
               REPZ   CMPSB
               JZ     MATCH                  ;If zero, we got a match.
               INC    BX                     ;Else, point to next offset.
               JNZ    NEXT_SEARCH            ;If back to zero, we are done.
               STC                           ;Indicate no match with carry.
               RET
MATCH:         CLC                           ;Indicate match with no carry.
               RET
 
;------------------------------------------------;
; This subroutine will display ASCII characters. ;
;------------------------------------------------;
 
ASCII:         LODSB                         ;Get a character.
               CMP    AL,32                  ;Is it below space?
               JB     END_ASCII              ;If yes, we are done.
               CMP    AL,'z'                 ;Is it above "z"?
               JA     END_ASCII              ;If yes, we are done.
               MOV    DL,AL                  ;Else, print it.
               CALL   PRINT_CHAR
               LOOP   ASCII                  ;Get next character.
END_ASCII:     RET
 
;-----------------------------------------------;
; This subroutine will display the free memory. ;
;-----------------------------------------------;
 
MEMORY:        XOR    BX,BX                  ;Shrink allocated memory to
               MOV    AH,4AH                 ; zero for current program
               INT    21H                    ; via DOS.
 
               MOV    AH,48H                 ;Request FFFFh paragraphs of
               MOV    BX,0FFFFH              ; memory. This will fail with
               INT    21H                    ; available paragraphs in BX.
 
               MOV    AX,BX
               XOR    DX,DX
               MOV    CX,64                  ;Divide by 64 to get memory
               DIV    CX                     ; in K bytes.
               CMP    DX,32
               JB     NO_CARRY
               INC    AX                     ;Round up if half or above.
 
NO_CARRY:      MOV    BX,AX
               MOV    DISPLAY_FLAG,0         ;Reset display flag.
               MOV    CX,10000               ;Get ten thousands by dividing.
               CALL   DIVIDE
               MOV    CX,1000                ;Get thousands by dividing.
               CALL   DIVIDE
               MOV    CX,100                 ;Get hundreds by dividing.
               CALL   DIVIDE
TENS:          MOV    CX,10                  ;Get tens by dividing.
               CALL   DIVIDE
               MOV    CX,1                   ;Get ones by dividing.
               CALL   DIVIDE
               RET
 
DIVIDE:        MOV    AX,BX                  ;Number in AX
               XOR    DX,DX                  ; and zero in DX
               DIV    CX                     ; divide by CX
               MOV    BX,DX                  ; remainder into BX
               MOV    DL,AL                  ; and quotient into DL.
               CMP    AL,0                   ;Is it zero?
               JZ     FLAG                   ;If yes, is a non-zero displayed?
               OR     DISPLAY_FLAG,AL        ;If non-zero, indicate by flag.
FLAG:          CMP    DISPLAY_FLAG,0         ;Non-zero no. been displayed?
               JA     DISPLAY                ;If yes, display else return
               RET                           ; to suppress leading zeros.
 
DISPLAY:       ADD    DL,30H                 ;Convert hexidecimal
               CALL   PRINT_CHAR             ; to decimal and display.
               RET
 
;--------------------------------------------;
; These are the two DOS display subroutines. ;
;--------------------------------------------;
 
PRINT_STRING:  MOV    AH,9                   ;Print string.
               INT    21H
               RET
 
PRINT_CHAR:    MOV    AH,2                   ;Display output.
               INT    21H
               RET
 
;--------------------------------------------------------------------;
; These two subroutines locate the cursor before displaying via DOS. ;
;--------------------------------------------------------------------;
 
LOCATE_STRING: CALL   LOCATE
               CALL   PRINT_STRING
               RET
 
LOCATE_CHAR:   CALL   LOCATE
               CALL   PRINT_CHAR
               RET
 
;-------------------------------------------;
; This subroutine sets the cursor position. ;
;-------------------------------------------;
 
LOCATE:        PUSH   DX                     ;Save the registers.
               PUSH   BX
               MOV    DX,BP                  ;Row/column.
               XOR    BH,BH                  ;Page zero.
               MOV    AH,2                   ;Set cursor postion
               INT    10H                    ; via BIOS.
               POP    BX
               POP    DX                     ;Restore registers.
               RET
 
;-----------------------------------------------------------------------;
; This subroutine prints 19 line characters for the box top and bottom. ;
;-----------------------------------------------------------------------;
 
PRINT_LINE:    MOV    CX,19
               MOV    DL,196
NEXT_LINE:     CALL   PRINT_CHAR
               LOOP   NEXT_LINE
               RET
 
;----------------------------------------------------------------------;
; This subroutine marks with an asterisk the appropriate bit settings. ;
;----------------------------------------------------------------------;
 
BITS:          MOV    CL,2                   ;Shift two bits to right.
               ROR    BX,CL
               MOV    DL,'*'
               TEST   BX,3                   ;Are bits one and two off?
               JZ     DISPLAY_BIT            ;If yes, display as is.
               SUB    BP,100H                ;Else, move up one row.
               TEST   BX,1                   ;Is bit one off?
               JZ     DISPLAY_BIT            ;If yes, display.
               SUB    BP,100H                ;Else, move up one row.
               TEST   BX,2                   ;Is bit two off?
               JZ     DISPLAY_BIT            ;If yes, display.
               SUB    BP,100H                ;Else, move up one row.
DISPLAY_BIT:   CALL   LOCATE_CHAR            ;Print the asterisk.
               RET
 
;------------------------------------------------------------------------;
; Text data is placed here so the Basic data listing is easier to enter. ;
;------------------------------------------------------------------------;
 
HEADING        DB  'PC Magazine System Checkout Utility$'
SWITCHES       DB  'Switches$'
TEXT:
DB 13,10
DB ' Bit 1                                Bits 5-6 initial video mode',13,10
DB '    0 = No disk drive installed          11 = 80X25 monochrome',13,10
DB '    1 = Disk drive installed             10 = 40X25 color',13,10
DB ' Bit 2                                   01 = 80X25 color',13,10
DB '    0 = No math coprocessor              00 = None',13,10
DB '    1 = Math coprocessor installed    Bits 7-8 no. of disks (if bit 1 =1)'
DB 13,10
DB ' Bits 3-4 memory on system board         11 = 4',13,10
DB '    XT/PC2        PC1       AT           10 = 3',13,10
DB '    11 = 256K     64K    Does not        01 = 2',13,10
DB '    10 = 192K     48K     apply          00 = 1',13,10
DB '    01 = 128K     32K',13,10
DB '    00 =  64K     16K$'
 
PARALLEL       DB ' Parallel port(s)$'
SERIAL         DB ' Serial port(s)$'
GAMEPORT       DB ' Game port$'
SYSTEM_MEMORY  DB 'Main memory     $'
FREE           DB 'Bytes free      $'
EXTENDED       DB 'Extended memory $'
EXPANDED       DB 'Expanded memory $'
DOS            DB 'DOS  version    $'
BIOS           DB 'BIOS version    $'
EMM            DB 'EMM'
IBM            DB 'IBM'
EGA            DB '(EGA)$'
NONE           DB 'None$'
 
CAP_COPR       DB 'COPR.'
LOWER_COPR     DB 'Copr.'
CAP_C          DB '(C)$'
LOWER_C        DB '(c)'
COPYR          DB 'Copyright'
 
CODE ENDS
END  START
