#include "animator.h"

static char  sztext[MAX_FILE_SIZE];
static char  szBarText[180];


//////////////////////////////////////////////////////////////////////////
// StatusBarProc - just draws what it is supposed to draw in the 
// form of a status bar.  The status bar displays the MDI child 
// window title and tells whether it is animating or not.
//////////////////////////////////////////////////////////////////////////

LRESULT _export CALLBACK StatusBarProc (WNDPROC_PARAMS)
{
    PAINTSTRUCT    ps;
    HDC            hDC;
    HPEN           hpnOld;
    HWND           hwndMDI ;
    RECT           rc;    

    /* No reason to use the Message Crackers here */

    if (uMsg == WM_PAINT)
    {
        hDC = BeginPaint (hWnd, &ps);

    // Set rect coordinates...
        GetClientRect (hWnd, &rc);
    
    // Draw Black line above bar...and save previously-selected pen
        hpnOld = SelectPen (hDC, _hpnBlack);
        MoveTo (hDC, rc.left, rc.top);
        LineTo (hDC, rc.right, rc.top);

    // Draw White shadows...
        SelectPen (hDC, _hpnWhite);
        MoveTo (hDC, rc.left, rc.top+1);
        LineTo (hDC, rc.right, rc.top+1);

    // Draw gray shadows...then re-select old pen back into context
        SelectPen (hDC, _hpnGray);
        MoveTo (hDC, 0, rc.bottom-1);
        LineTo (hDC, rc.right, rc.bottom-1);
        SelectPen (hDC, hpnOld);

    // Do text...
        SetBkColor (hDC, GetSysColor(COLOR_BTNFACE));
        SetTextColor (hDC, GetSysColor(COLOR_BTNTEXT));
        SelectFont (hDC, GetStockFont(ANSI_VAR_FONT));

        if (hwndMDI = MDI_GetActive(_hwndClient))
        {
            short sChild = WINDOWNUM(hwndMDI);

            GetWindowText (hwndMDI, (LPSTR)sztext, sizeof(sztext));         

            if (ISANIMATING(sChild) && !EXELOADED(sChild))
            {
                wsprintf ((LPSTR)szBarText, (LPSTR)"%s %s", 
                          (LPSTR)sztext, (LPSTR)"will animate when target is loaded");
            }
            else if (ISANIMATING(sChild) && EXELOADED(sChild))
            {
                wsprintf ((LPSTR)szBarText, (LPSTR)"%s is %s", 
                          (LPSTR)sztext, (LPSTR)"animating");
            }
            else if (TIMEINT(sChild) && SZEXELINK(sChild)[0] && 
                (!ISANIMATING(sChild)))
            {
                wsprintf ((LPSTR)szBarText, (LPSTR)"%s is %s", 
                          (LPSTR)sztext, 
                          (LPSTR)"is currently ready but stopped");
            }
            else if (TIMEINT(sChild) && (!SZEXELINK(sChild)[0]))
            {
                wsprintf ((LPSTR)szBarText, 
                          (LPSTR)"%s needs to link to an application",
                          (LPSTR)sztext);
            }
            else if ((!TIMEINT(sChild)) && SZEXELINK(sChild)[0])
            {
                wsprintf ((LPSTR)szBarText, (LPSTR)"%s needs a timer setting",
                    (LPSTR)sztext);
            }
        }
        else
        {
            wsprintf ((LPSTR)szBarText,(LPSTR)"No Animations currently open");
        }

        rc.left += 10;  // just add a cheap indent...

        DrawText (hDC, szBarText, lstrlen (szBarText), &rc, 
            DT_NOCLIP|DT_SINGLELINE|DT_VCENTER|DT_LEFT);

        EndPaint (hWnd, &ps);
        return 0L;
    }

    return DefWindowProc (hWnd, uMsg, wParam, lParam);
}
        
        
        
