//
//  About box object for C++ OWL
//
//  Copyright 1993 by Danny Thorpe
//

#include "about.h"

TCreditWindow::TCreditWindow(PTWindowsObject AParent,
                  LPCSTR ABitmapName, LPSTR AStringList[])
        : TWindow(AParent, NULL)
{
  HDC DC;
  HFONT OldFont;
  TEXTMETRIC TM;
  LPSTR P;

  Attr.Style = WS_CHILD | WS_VISIBLE;
  Bitmap = LoadBitmap(GetApplication()->hInstance, ABitmapName);
  if (!Bitmap)
  {
    Status = EM_INVALIDWINDOW;
    return;
  };
  GetObject(Bitmap, sizeof(BitSize), &BitSize);
  ScrollPos = 0;
  DC = GetDC(0);
  ScrollUnit = 2;
  ScrollRate = 80;
  OldFont = SelectObject(DC, GetStockObject(ANSI_VAR_FONT));
  GetTextMetrics(DC, &TM);
  FontHeight = TM.tmHeight + TM.tmExternalLeading + 5;
  SelectObject(DC, OldFont);
  ReleaseDC(0, DC);
  StringList = AStringList;

  // Count strings in stringlist.
  for (StringCount = 0; StringList[StringCount]; StringCount++);
};

TCreditWindow::~TCreditWindow()
{
  DeleteObject(Bitmap);
};

void TCreditWindow::GetWindowClass(WNDCLASS& WC)
{
  TWindow::GetWindowClass(WC);
  WC.style = CS_BYTEALIGNWINDOW;   // for BitBlt speed 
  WC.hbrBackground = GetStockObject(BLACK_BRUSH);
};

void TCreditWindow::SetupWindow()
{
  TWindow::SetupWindow();
  SetWindowPos(HWindow, 0, 0, 0, BitSize.bmWidth, BitSize.bmHeight,
               SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOREDRAW);
};

void TCreditWindow::WMDestroy(RTMessage Msg)
{
  if (ScrollPos) // We're scrolling and need to kill the timer 
  {
    KillTimer(HWindow, 1);
    ScrollPos = 0;
  };
  TWindow::WMDestroy(Msg);
};

void DrawBitmap(HDC DC, int X, int Y, int W, int H, HBITMAP Bitmap)
{
  HDC MemDC = CreateCompatibleDC(DC);
  HBITMAP OldBits = SelectObject(MemDC, Bitmap);
  BitBlt(DC, X, Y, W, H, MemDC, 0, 0, SRCCOPY);
  SelectObject(MemDC, OldBits);
  DeleteDC(MemDC);
};

void TCreditWindow::Paint(HDC DC, PAINTSTRUCT& PS)
{
  RECT R;
  int FirstLine, LastLine, Y;

  SaveDC(DC);
  SetViewportOrg(DC, 0, -ScrollPos);
  OffsetRect(&PS.rcPaint, 0, ScrollPos);
  R.left = 0;
  R.top = 0;
  R.right = Attr.W;
  R.bottom = Attr.H;
  if (IntersectRect(&R, &PS.rcPaint, &R))
  {
    DrawBitmap(DC, 0, 0, Attr.W, Attr.H, Bitmap);
    if ((R.top < PS.rcPaint.top) && (R.bottom > PS.rcPaint.top))
      PS.rcPaint.top = R.bottom;
    if ((R.top < PS.rcPaint.bottom) && (R.bottom > PS.rcPaint.bottom))
      PS.rcPaint.bottom = R.top;
    if (PS.rcPaint.top > PS.rcPaint.bottom)
      PS.rcPaint.top = PS.rcPaint.bottom;
  };
  if (ScrollPos > 0)    // we're scrolling 
  {
    FirstLine = (PS.rcPaint.top - Attr.H) / FontHeight;
    if (FirstLine < 0)
      FirstLine = 0;
    if (FirstLine < StringCount)
    {                             // we have text to draw 
      SetTextAlign(DC, TA_CENTER);
      SetBkColor(DC, 0);
      SetTextColor(DC, RGB(0xff,0xff,0xff));
      LastLine = (PS.rcPaint.bottom - Attr.H) / FontHeight;
      for (Y = FirstLine; Y <= LastLine; Y++)
      {
        if (Y < StringCount)
          TextOut(DC, Attr.W / 2, Y*FontHeight + Attr.H,
                      StringList[Y], _fstrlen(StringList[Y]));
      };
    };
                            // Paint second image of bitmap at bottom 
    if (PS.rcPaint.bottom > (Attr.H + FontHeight * StringCount))
      DrawBitmap(DC, 0, Attr.H + FontHeight * StringCount,
                     Attr.W, Attr.H, Bitmap);
  };
  RestoreDC(DC, -1);
};

void TCreditWindow::ShowCredits()
{
  SetTimer(HWindow, 1, ScrollRate, NULL);
};

void TCreditWindow::WMTimer(RTMessage)
{
  ScrollPos += ScrollUnit;
  // Check to see if it's time to stop scrolling 
  if (ScrollPos > Attr.H + FontHeight * StringCount)
  {
    ScrollPos = 0;
    KillTimer(HWindow, 1);
    InvalidateRect(HWindow, NULL, FALSE);
  }
  else
    ScrollWindow(HWindow, 0, -ScrollUnit, NULL, NULL);
  UpdateWindow(HWindow);
};

//*********************************************************

TAboutBox::TAboutBox(PTWindowsObject AParent,
                     LPCSTR ATitle,
                     LPCSTR ABitmapName,
                     LPSTR AStringList[],
                     LPSTR AResName) :
     TDialog(AParent, AResName)
{
  Title = _fstrdup(ATitle ? ATitle : "");
  BitmapName = ABitmapName;
  StringList = AStringList;
};

TAboutBox::~TAboutBox()
{
  if ( HIWORD(Title) )
    farfree((void*)Title);
};

void TAboutBox::SetupWindow()
{
  RECT RDialog,R,RBitWnd,RShade,RBump,ROk;
  int X8, Y8;
  HDC DC;

  InitCreditWindow(BitmapName, StringList);
  TDialog::SetupWindow();
  SetWindowText(HWindow, Title);
  DC = GetDC(HWindow);               
  X8 = GetDeviceCaps(DC,LOGPIXELSX) / 8;   // 1/8 inch 
  Y8 = GetDeviceCaps(DC,LOGPIXELSY) / 8;
  ReleaseDC(HWindow, DC);
  GetClientRect(GetDlgItem(HWindow, IDSHADE), &RShade);
  GetClientRect(GetDlgItem(HWindow, IDBUMP), &RBump);
  GetClientRect(GetDlgItem(HWindow, IDOK), &ROk);
  GetClientRect(CreditWindow->HWindow, &RBitWnd);
  RShade.top = Y8;
  RShade.left = X8;
  if (RShade.right < RBitWnd.right + 2*X8)
    RShade.right = RBitWnd.right + 2*X8;
  if (RShade.bottom < RBitWnd.bottom + 2*Y8)
    RShade.bottom = RBitWnd.bottom + 2*Y8;

  GetWindowRect(HWindow, &RDialog);
  GetClientRect(HWindow, &R);
  RDialog.right = RDialog.right - RDialog.left - R.right;
  RDialog.bottom = RDialog.bottom - RDialog.top - R.bottom;
  RDialog.right += X8 + RShade.right + X8;   // 1/8 inch margins
  RDialog.bottom +=  Y8 + RShade.bottom
                   + Y8 + RBump.bottom
                   + Y8 + ROk.bottom + Y8;
  if (Parent)
  {
    GetWindowRect(Parent->HWindow, &R);
//         Center dialog in parent's window
    RDialog.left = R.left + (R.right - R.left) / 2
                          - RDialog.right / 2;
    RDialog.top = R.top + (R.bottom - R.top) / 2
                        - RDialog.bottom / 2;
  };
  SetWindowPos(HWindow, 0, RDialog.left, RDialog.top,
                        RDialog.right, RDialog.bottom,
                        SWP_NOACTIVATE | SWP_NOZORDER);

  SetWindowPos(GetDlgItem(HWindow, IDSHADE), 0, RShade.left,
               RShade.top, RShade.right, RShade.bottom,
               SWP_NOACTIVATE | SWP_NOZORDER);
  SetWindowPos(CreditWindow->HWindow, 0,  RShade.left + X8,
               RShade.top + Y8, 0, 0,
               SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

  RBump.left = -1;
  RBump.right = RDialog.right + 2;
  RBump.top = RShade.top + RShade.bottom + Y8;
  SetWindowPos(GetDlgItem(HWindow, IDBUMP), 0, RBump.left,
               RBump.top, RBump.right, RBump.bottom,
               SWP_NOACTIVATE | SWP_NOZORDER);

  GetClientRect(HWindow, &R);
  SetWindowPos(GetDlgItem(HWindow, IDOK), 0,
               R.right / 2 - ROk.right / 2,
               RBump.top + RBump.bottom + Y8, 0, 0,
               SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);
};

void TAboutBox::InitCreditWindow(LPCSTR ABitmapName, LPSTR AStringList[])
{
  CreditWindow = new TCreditWindow(this, ABitmapName, AStringList);
};

void TAboutBox::ShowCredits(RTMessage)
{
  CreditWindow->ShowCredits();
};