/*--------------------------------------
   PATHS.C -- Path Operations
              (c) Charles Petzold, 1993
  --------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>

void PaintClient (HPS hps, SHORT cxClient, SHORT cyClient)
     {
     int    x, y ;
     POINTL ptl ;

     for (x = 0 ; x < 3 ; x++)
     for (y = 0 ; y < 2 ; y++)
          {
                    // Create an open sub-path

          GpiBeginPath (hps, 1) ;

          ptl.x = (1 + 10 * x) * cxClient / 30 ;
          ptl.y = (4 +  5 * y) * cyClient / 10 ;
          GpiMove (hps, &ptl) ;

          ptl.x = (5 + 10 * x) * cxClient / 30 ;
          ptl.y = (2 +  5 * y) * cyClient / 10 ;
          GpiLine (hps, &ptl) ;

          ptl.x = (9 + 10 * x) * cxClient / 30 ;
          ptl.y = (4 +  5 * y) * cyClient / 10 ;
          GpiLine (hps, &ptl) ;

                    // Create a closed sub-path

          ptl.x = (1 + 10 * x) * cxClient / 30 ;
          ptl.y = (3 +  5 * y) * cyClient / 10 ;
          GpiMove (hps, &ptl) ;

          ptl.x = (5 + 10 * x) * cxClient / 30 ;
          ptl.y = (1 +  5 * y) * cyClient / 10 ;
          GpiLine (hps, &ptl) ;

          ptl.x = (9 + 10 * x) * cxClient / 30 ;
          ptl.y = (3 +  5 * y) * cyClient / 10 ;
          GpiLine (hps, &ptl) ;

          GpiCloseFigure (hps) ;
          GpiEndPath (hps) ;

                    // Possibly modify the path

          if (y == 0)
               {
               GpiSetLineWidthGeom (hps, cxClient / 30) ;
               GpiModifyPath (hps, 1, MPATH_STROKE) ;
               }

                    // Perform the operation

          GpiSetLineWidth (hps, LINEWIDTH_THICK) ;
          GpiSetLineWidthGeom (hps, cxClient / 50) ;
          GpiSetPattern (hps, PATSYM_HALFTONE) ;

          switch (x)
               {
               case 0:  GpiOutlinePath (hps, 1, 0) ;             break ;
               case 1:  GpiStrokePath (hps, 1, 0) ;              break ;
               case 2:  GpiFillPath (hps, 1, FPATH_ALTERNATE) ;  break ;
               }
          }
     }
