***********************************************************************
* BROWPICK.PRG - Demonstrate use of the BROWPICK function.
***********************************************************************
SET ECHO OFF
SET TALK OFF
CLEAR
SET SYSMENU OFF
pcmag="PC Magazine Databases PC Magazine Databases PC Magazine Data"+;
      "bases PC Magazine "
@ 0, 0, 24, 79 BOX
FOR i = 1 TO 23
   @ i, 1 SAY pcmag
ENDFOR
* All fields
USE C:\FOXPROW\BKINV
cTable = BROWPICK( DBF(), "Book Catalog-All Titles")
IF "" <> cTable
  CLEAR
  LIST FIELDS Title, Pubdate
  USE
  DELETE FILE (cTable)
ENDIF
WAIT
CLEAR
@ 0, 0, 24, 79 BOX
FOR i = 1 TO 23
   @ i, 1 SAY pcmag
ENDFOR
* Selected fields and where clause
SELECT Bkinv
cTable = BROWPICK( DBF(), "Book Catalog-Selected Titles", ;
  "Title, Pubdate", "Pubid=='000001'")
IF "" <> cTable
  CLEAR
  LIST FIELDS Title, Pubdate
  USE
  DELETE FILE (cTable)
ENDIF
CLOSE ALL
RETURN

**********************************************************************
* FUNCTION BROWPICK - Browse a table as a picklist and allow multiple
* selections. Press Spacebar to toggle selections. Press Enter or
* Ctrl+W to terminate the Browse window.
*
* Call with arguments: Table/DBF name, title for the Browse
* window, optional field list, optional WHERE clause
*
* Returns name of temporary table containing the selected records, or
* empty string if Esc is pressed. Note that table may be empty if
* Enter is pressed without making any selections.
*
* If a table name is returned it is the callers responsibility to
* erase the temporary table when you're done with it.
**********************************************************************
FUNCTION BROWPICK
PARAMETER cTbl, cTitle, cFieldlist, cWhere
PRIVATE cTmp
cOldBell = SET("BELL")
SET BELL OFF
IF EMPTY(cFieldlist)
  cFieldlist = '*'
ENDIF
IF EMPTY(cWhere)
  SELECT " " AS Check, &cFieldlist FROM (cTbl) INTO TABLE SYS(3)
ELSE
  SELECT " " AS Check, &cFieldlist FROM (cTbl) WHERE &cWhere ;
  INTO TABLE SYS(3)
ENDIF
ON KEY LABEL SPACEBAR DO CHKMARK
ON KEY LABEL ENTER KEYBOARD CHR(23)
cScheme1 = SCHEME(1)
SET COLOR OF SCHEME 1 TO SCHEME 10
@ SROWS()-1, 7 SAY "Press Spacebar to toggle selection, Enter to " + ;
 "finish, Esc to cancel"
SET COLOR OF SCHEME 1 TO &cScheme1
DEFINE WINDOW BROWPICK FROM 3, 6 TO 21, 73 COLOR SCHEME 10
BROWSE NOMODIFY NOMENU NOAPPEND NODELETE TITLE cTitle WINDOW BROWPICK
RELEASE WINDOW BROWPICK
ON KEY LABEL SPACEBAR
ON KEY LABEL ENTER
SET BELL &cOldBell
@ SROWS()-1, 5
IF LASTKEY()==27
  cTmp=DBF()
  USE
  DELETE FILE (cTmp)
ELSE
  DELETE ALL FOR Check <> CHR(251)
  PACK
ENDIF
RETURN DBF()

*********************************************************************
* PROCEDURE CHKMARK
* Toggle the selection marker on the current record, refresh the
* Browse window display.
*********************************************************************
PROCEDURE CHKMARK
REPLACE Check WITH IIF(Check==" ", CHR(251), " ")
SHOW WINDOW (WONTOP()) REFRESH
RETURN

