*********************************************************************
*  FUNCTION NxtKeyCod                                     Clipper 5
*  Increments a key code of serial number that is made up of
*  letters and numerals.
*
*  - The characters used in the code are from 0 - 9 and then A - Z
*    in ascending order.
*  - The previous key code passed to this procedure should have the
*    maximum length allowed so that the system can check whether
*    the next key code will exceed the limit.
*    If so, it returns all "*".
*  - Spaces are treated as "0".  Trailing spaces are significant and
*    replaced by "0", while leading spaces will remain unchanged
*********************************************************************
FUNCTION NxtKeyCod( ckeycode )
LOCAL cchrbank, nkeylen, nct, cwkchr, nwkchrseq
cchrbank = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
nkeylen = LEN( ckeycode)
ckeycode = SUBSTR( TRIM( ckeycode ) + ;
  REPLICATE( "0", nkeylen), 1, nkeylen)
FOR nct = 1 TO nkeylen
   cwkchr     = SUBSTR( ckeycode, -1 *nct, 1 )
   cwkchr     = IIF( cwkchr = " ", "0", cwkchr )
   nwkchrseq  = AT( cwkchr, cchrbank )
   nwkchrseq  = nwkchrseq + 1
   nwkchrseq  = IIF( nwkchrseq > LEN( cchrbank), 1, nwkchrseq )
   cwkchr     = SUBSTR( cchrbank, nwkchrseq, 1 )
   ckeycode   = SUBSTR( ckeycode, 1, nkeylen - nct) + cwkchr +;
      SUBSTR( ckeycode, nkeylen -nct +2)
   IF nwkchrseq != 1
      EXIT
   ELSEIF nct = nkeylen
      ckeycode = REPLICATE( "*", nkeylen )
   ENDIF
NEXT
RETURN ckeycode
