//========================================================================
// 
//  RCHook.C - The Message Hook DLL for RClick
//
//  (c) Douglas Boling 1993
//
//  For better readability, set tab stops to every 3 characters.
//
//========================================================================

#define  WINVER      0x0300
#define	MAXWINDOWS	128

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "rchook.h"
//
//Structures
//
typedef struct {
	LONG	lParam;
	int	wParam;
	UINT  uMsg;
	HWND  hWnd;
} CALLHOOKDATA;
typedef CALLHOOKDATA far *LPCALLHOOKDATA;
//
// Function prototypes
//
long FAR PASCAL	WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL ConfigDlgProc (HWND, WORD, WORD, LONG);
void SetHook (BOOL);
void CopyMenuBitmap (HMENU, UINT, UINT);
void CopyMenu (HMENU, HMENU);

char     szDllName[] = "RCHook";

HANDLE	hInst;
FARPROC	lpfnNextHook;
FARPROC	lpfnNextHook1;
int		sHooked = 0;
char		szStr[64];

int      sNumNoPopProgs;
char		szNoPopPrograms[MAXWINDOWS][12];

HMENU		hMenu, hProgMenu;
HWND		hwndMyWin, hwndTarg;
BOOL		bMenuUp, bGetCMD;
//=======================================================================
//
// Library initialization and terminataion functions
//
//=======================================================================
//------------------------------------------------------------------------
// LibMain - DLL initialization routine
//------------------------------------------------------------------------
int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
	                     LPSTR lpszCmdLine) {
	hInst = hInstance;
	bMenuUp = FALSE;
	bGetCMD = FALSE;
	sNumNoPopProgs = 0;

	if (sHooked == 0) SetHook (TRUE);
	return 1;
}
//------------------------------------------------------------------------
// WEP - DLL termination routine
//------------------------------------------------------------------------
int FAR PASCAL WEP (int nParameter) {
   
	if (sHooked) SetHook (FALSE);
   if (bMenuUp) {
      DestroyMenu (hMenu);
   }   
	return 1;
}
//===================================================================
// Local procedures
//===================================================================
//-------------------------------------------------------------------
// SetHook - Sets or Clears the message queue hook
//-------------------------------------------------------------------
void SetHook (BOOL bEnable) {
	if (bEnable) {
		if (sHooked == 0) {
			lpfnNextHook = SetWindowsHook (WH_GETMESSAGE, 
		                               GetProcAddress (hInst, "MsgHookProc"));

			lpfnNextHook1 = SetWindowsHook (WH_CALLWNDPROC,
		                               GetProcAddress (hInst, "CallHookProc"));
			sHooked++;
		}
	} else {
		if (sHooked) {
	 		UnhookWindowsHook (WH_GETMESSAGE,
			                   GetProcAddress (hInst, "MsgHookProc"));

	 		UnhookWindowsHook (WH_CALLWNDPROC,
			                   GetProcAddress (hInst, "CallHookProc"));
		sHooked--;
		}
	}
	return;
}

//-------------------------------------------------------------------
// CopyMenuBitmap - Copys a bitmap menu item
//-------------------------------------------------------------------
void CopyMenuBitmap (HMENU hPopMenu, UINT usMenuState, UINT usMenuID) {
   
	usMenuState &= ~MF_BITMAP;            
	switch (usMenuID) {
	   case 0xf120:
		   AppendMenu (hPopMenu, usMenuState, usMenuID, "Restore");
		   break;
		default:
			AppendMenu (hPopMenu, usMenuState, usMenuID, "Bitmap");
			break;
	}
	return;
}	

//-------------------------------------------------------------------
// CopyMenu - Copys the menu from a window to the popup menu
//-------------------------------------------------------------------
void CopyMenu (HMENU hPopMenu, HMENU hSrcMenu) {
   int	i, sMenuItems;
   UINT	usMenuID, usMenuState;
   HMENU	hSubMenu;
   
	sMenuItems = GetMenuItemCount (hSrcMenu);
	for (i = 0; i < sMenuItems; i++) {
		usMenuID = GetMenuItemID (hSrcMenu, i);
		usMenuState = GetMenuState (hSrcMenu, i, MF_BYPOSITION);
	   if (usMenuID == 0xffff) {
	      hSubMenu = CreatePopupMenu ();
	      CopyMenu (hSubMenu, GetSubMenu (hSrcMenu, i));
         if (usMenuState & MF_BITMAP) {
            CopyMenuBitmap (hPopMenu, MF_POPUP, hSubMenu);
			} else {
				GetMenuString (hSrcMenu, i, szStr, sizeof (szStr),
				               MF_BYPOSITION);
				AppendMenu (hPopMenu, MF_POPUP, hSubMenu, szStr);
			}
	   } else {  
         if (usMenuState & MF_BITMAP) {
            CopyMenuBitmap (hPopMenu, usMenuState, usMenuID);
         } else {   
			   GetMenuString (hSrcMenu, i, szStr, sizeof (szStr),
			                  MF_BYPOSITION);
			   AppendMenu (hPopMenu, usMenuState, usMenuID, szStr);
			}   
	   }	            
   }
}

//===================================================================
// Send Message Hook function
//===================================================================
LRESULT FAR PASCAL CallHookProc (int code, WORD wParam, LONG lParam) {

	LPCALLHOOKDATA	lpmMsg;

	lpmMsg = (LPCALLHOOKDATA) lParam;

	if (code < 0) 
	   return DefHookProc (code, wParam, lParam, &lpfnNextHook1);

	if (bMenuUp && (lpmMsg->uMsg == WM_COMMAND)) {
	   bGetCMD = FALSE;

		if (lpmMsg->wParam == 0x7fff) {
			PostMessage (hwndMyWin, RBM_SHOWABOUTDLG, hwndTarg, 0);
	      lpmMsg->uMsg = WM_NULL;
	   }
		if (lpmMsg->wParam == 0x7ffe) {
			hwndTarg  = lpmMsg->hWnd;
			PostMessage (hwndMyWin, RBM_SHOWCONFIGDLG, hwndTarg, 0);
	      lpmMsg->uMsg = WM_NULL;
		}
	}
	return DefHookProc (code, wParam, lParam, &lpfnNextHook1);
   
}   
//===================================================================
// Post Message Hook function
//===================================================================
LRESULT FAR PASCAL MsgHookProc (int code, WORD wParam, LONG lParam) {

	int		i;
	LPMSG		lpmMsg;
	HMENU		hWinMenu;
	char 		*pszModuleName;

	if (code < 0) 
	   return DefHookProc (code, wParam, lParam, &lpfnNextHook);
	
	lpmMsg = (LPMSG) lParam;

	//
	//Check for Right Button Down
	//
	if (lpmMsg->message == WM_RBUTTONDOWN && !bMenuUp) {

	   hwndTarg = lpmMsg->hwnd;
	   while (GetParent (hwndTarg) != GetDesktopWindow() && 
		       GetParent (hwndTarg) != 0)
	      hwndTarg = GetParent(hwndTarg);
      
		if (hWinMenu = GetMenu (hwndTarg)) {
			bMenuUp = TRUE;
			GetModuleFileName (GetWindowWord (hwndTarg, GWW_HINSTANCE),
			                   szStr, sizeof (szStr));

			pszModuleName = strrchr(szStr, '\\')+1;
		   for (i = 0; i < sNumNoPopProgs; i++) {
		      if (strcmp (pszModuleName, szNoPopPrograms[i]) == 0) {
		         bMenuUp = FALSE;
		         break;
		      }
		   }  
		   if (bMenuUp && (i = GetMenuItemCount (hWinMenu))) {
				if (hMenu = CreatePopupMenu()) {
				   
				   CopyMenu (hMenu, hWinMenu);
					hProgMenu = CreatePopupMenu();

				   AppendMenu (hProgMenu, MF_ENABLED,
	   	            0x7ffe, (LPSTR) "Configure Rclick...");
				   AppendMenu (hProgMenu, MF_ENABLED,
	   	            0x7fff, (LPSTR) "About RClick...");
				   
				   AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
				   AppendMenu (hMenu, MF_POPUP, hProgMenu, (LPSTR) "RClick");

			      bGetCMD = TRUE;				   
					TrackPopupMenu (hMenu, 0, lpmMsg->pt.x-10, 
					                lpmMsg->pt.y-5, 0, hwndTarg, 0);
			      DestroyMenu (hMenu);
			      lpmMsg->message = WM_NULL;
				}
			}
	      bMenuUp = FALSE;
			return 0;
		} 
	}
	//
	//Check for WM_COMMAND
	//
	if (bGetCMD && (lpmMsg->message == WM_COMMAND)) {
	   bGetCMD = FALSE;

		if (lpmMsg->wParam == 0x7fff) {
			PostMessage (hwndMyWin, RBM_SHOWABOUTDLG, hwndTarg, 
			             MAKELONG (lpmMsg->pt.y, lpmMsg->pt.x));
	      lpmMsg->message = WM_NULL;
	   }
		if (lpmMsg->wParam == 0x7ffe) {
			hwndTarg  = lpmMsg->hwnd;
			PostMessage (hwndMyWin, RBM_SHOWCONFIGDLG, hwndTarg, 
			             MAKELONG (lpmMsg->pt.y, lpmMsg->pt.x));
	      lpmMsg->message = WM_NULL;
		}

	}
   return DefHookProc (code, wParam, lParam, &lpfnNextHook);
}

//===================================================================
// Library exported functions
//===================================================================
//-------------------------------------------------------------------
// GetStatus - Returns Status information
//-------------------------------------------------------------------
VOID FAR PASCAL GetStatus (PHOOKSTAT phsStatus){

	phsStatus -> hwndMyWin = hwndMyWin;
	phsStatus -> sNoPopCnt = sNumNoPopProgs;
	if (sHooked)
		phsStatus -> bEnabled = TRUE;
	else 
		phsStatus -> bEnabled = FALSE;
 	return;
}
//-------------------------------------------------------------------
// SetStatus - Returns Status information
//-------------------------------------------------------------------
VOID FAR PASCAL SetStatus (PHOOKSTAT phsStatus){

	hwndMyWin = phsStatus -> hwndMyWin;
	if (phsStatus -> bEnabled)
	   SetHook (TRUE);
	else 
	   SetHook (FALSE);
 	return;
}
//-------------------------------------------------------------------
// GetNoPop - Returns the name in no pop list
//-------------------------------------------------------------------
VOID FAR PASCAL GetNoPop (int sIndex, LPSTR lpszNoPopName) {

	if (sIndex < sNumNoPopProgs) {
	   lstrcpy (lpszNoPopName, szNoPopPrograms[sIndex]);
	}   
	return;
}
//-------------------------------------------------------------------
// SetNoPop - Adds program name to no pop list
//-------------------------------------------------------------------
VOID FAR PASCAL SetNoPop (LPSTR lpszNoPopName) {

	if (sNumNoPopProgs < MAXWINDOWS - 1) {
	   lstrcpy (szNoPopPrograms[sNumNoPopProgs++], lpszNoPopName);
	}
	return;
}	
//-------------------------------------------------------------------
// RemoveNoPop - Removes a program name from the no pop list
//-------------------------------------------------------------------
VOID FAR PASCAL RemoveNoPop (LPSTR lpszNoPopName) {

	int	i, j;
	
   for (i = 0; i < sNumNoPopProgs; i++) {
      if (lstrcmp (lpszNoPopName, (LPSTR) szNoPopPrograms[i]) == 0) {
			for (j = i; j < sNumNoPopProgs - 1; j++) 
			   strcpy (szNoPopPrograms[j], szNoPopPrograms[j+1]);
         break;
      }
   }
   sNumNoPopProgs--;
	return;
}
