//
// ProcMon.H -- Header File for Windows/NT example program ProcMon.C
//

#define WIN16     FALSE
#define THUMBPOS  HIWORD(wParam)

struct decodeMsg {                         	// structure associates
    UINT Code;                              // messages or menu IDs
    LONG (*Fxn)(HWND, UINT, UINT, LONG); }; // with a function

struct decodeUINT {                         // structure associates
    UINT Code;                              // UINTs with a string
    char * Name; };                         

struct decodeCounter {                     	// structure associates
    UINT Code;                              // Counters with a string 
    char * Name; 							// and size
	UINT Size; };                         

#define PERF_CTR_32BIT  1
#define PERF_CTR_64BIT  2
#define PERF_CTR_NODATA 3
#define PERF_CTR_TEXT   4

// declare pointer types for performance
// data structures defined in WINPERF.H
typedef PERF_DATA_BLOCK          *PPERFDATA;
typedef PERF_OBJECT_TYPE         *PPERFGROUP;
typedef PERF_INSTANCE_DEFINITION *PPERFINSTANCE;
typedef PERF_COUNTER_BLOCK       *PPERFCOUNTER;
typedef PERF_COUNTER_DEFINITION  *PPERFCOUNTERDEF;

// arbitrary menu identifiers
#define  IDM_EXIT     101
#define  IDM_ABOUT    102
#define	 IDM_OBJECT   103
#define  IDM_PROCESS  104
#define  IDM_REFRESH  105

// Function prototypes
int APIENTRY WinMain(HANDLE, HANDLE, PSTR, int);
BOOL InitApp(HANDLE, int);
BOOL TermApp(HANDLE);
LONG CALLBACK FrameWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
WORD CALLBACK TimerProc(HWND, UINT, UINT, LONG);
LONG DoDestroy(HWND, UINT, UINT, LONG);
LONG DoClose(HWND, UINT, UINT, LONG);
LONG DoCreate(HWND, UINT, UINT, LONG);
LONG DoSize(HWND, UINT, UINT, LONG);
LONG DoCommand(HWND, UINT, UINT, LONG);
LONG DoMenuExit(HWND, UINT, UINT, LONG);
LONG DoMenuAbout(HWND, UINT, UINT, LONG);
LONG DoRefresh(HWND, UINT, UINT, LONG);
VOID AddLeftLine(char *);
VOID AddRightLine(char *);
VOID UpdateProfile(VOID);
VOID EmptyLeftLines(VOID);
VOID EmptyRightLines(VOID);
VOID ShowProcesses(VOID);
VOID ShowCounters(PPERFINSTANCE);
BOOL GetPerfData(VOID);
BOOL GetObjectTitles(VOID);
PSTR FindTitle(INT);
PPERFGROUP FindGroup(PSTR);
INT FindCounterType(DWORD);
PPERFINSTANCE FindProcess(PSTR);

