/*------------------------------------------
   BITFONTS.C -- Displays OS/2 Bitmap Fonts
                 (c) Charles Petzold, 1993
  ------------------------------------------*/

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "bitfonts.h"

#define LCID_FONT   1

MRESULT EXPENTRY ClientWndProc (HWND, ULONG, MPARAM, MPARAM) ;

int main (void)
     {
     static CHAR  szClientClass [] = "BitFonts" ;
     static ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU  |
                                 FCF_SIZEBORDER    | FCF_MINMAX   |
                                 FCF_SHELLPOSITION | FCF_TASKLIST |
                                 FCF_MENU ;
     HAB          hab ;
     HMQ          hmq ;
     HWND         hwndFrame, hwndClient ;
     QMSG         qmsg ;

     hab = WinInitialize (0) ;
     hmq = WinCreateMsgQueue (hab, 0) ;

     WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0) ;

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                     &flFrameFlags, szClientClass,
                                     "Bitmap Fonts", 0L,
                                     NULLHANDLE, ID_RESOURCE, &hwndClient) ;

     while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0))
          WinDispatchMsg (hab, &qmsg) ;

     WinDestroyWindow (hwndFrame) ;
     WinDestroyMsgQueue (hmq) ;
     WinTerminate (hab) ;
     return 0 ;
     }

LONG GetAllBitmapFonts (HPS hps, PFONTMETRICS * ppfm)
     {
     HDC          hdc ;
     LONG         l, lAllFnt, lBitFnt, xRes, yRes ;
     PFONTMETRICS pfmAll, pfmBit ;

               // Find number of fonts

     lAllFnt = 0 ;
     lAllFnt = GpiQueryFonts (hps, QF_PUBLIC, NULL, &lAllFnt, 0, NULL) ;

     if (lAllFnt ==  0)
          return 0 ;

               // Allocate memory for FONTMETRICS structures

     pfmAll = (PFONTMETRICS) calloc (lAllFnt, sizeof (FONTMETRICS)) ;

     if (pfmAll == NULL)
          return 0 ;

     pfmBit = (PFONTMETRICS) calloc (lAllFnt, sizeof (FONTMETRICS)) ;

     if (pfmBit == NULL)
          {
          free (pfmAll) ;
          return 0 ;
          }
               // Get all fonts

     GpiQueryFonts (hps, QF_PUBLIC, NULL, &lAllFnt,
                         sizeof (FONTMETRICS), pfmAll) ;

               // Determine font resolution

     hdc = GpiQueryDevice (hps) ;

     DevQueryCaps (hdc, CAPS_HORIZONTAL_FONT_RES, 1, &xRes) ;
     DevQueryCaps (hdc, CAPS_VERTICAL_FONT_RES,   1, &yRes) ;

               // Get all the bitmap fonts

     lBitFnt = 0 ;

     for (l = 0 ; l < lAllFnt ; l++)
          {
          if (!(pfmAll[l].fsDefn & FM_DEFN_OUTLINE) &&
                pfmAll[l].sXDeviceRes == xRes       &&
                pfmAll[l].sYDeviceRes == yRes)
               {
               pfmBit [lBitFnt ++] = pfmAll [l] ;
               }
          }
               // Clean up

     free (pfmAll) ;
     pfmBit = (PFONTMETRICS) realloc (pfmBit, lBitFnt * sizeof (FONTMETRICS)) ;

     * ppfm = pfmBit ;

     return lBitFnt ;
     }

MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
     {
     static BOOL         fItalic, fUnder, fOutline, fStrike, fBold,
                         fBaseline, fTextBox ;
     static FATTRS       fat ;
     static HWND         hwndMenu ;
     static LONG         lFonts ;
     static PFONTMETRICS pfm ;
     static SHORT        cyClient ;
     CHAR                szBuffer [FACESIZE + 32] ;
     FONTMETRICS         fm ;
     HPS                 hps ;
     int                 i ;
     LONG                l ;
     POINTL              ptl, aptl [TXTBOX_COUNT] ;

     switch (msg)
	  {
          case WM_CREATE:
                         // Get the array of FONTMETRICS structures

               hps = WinGetPS (hwnd) ;
               GpiQueryFontAction (hps, QFA_PUBLIC) ;
               lFonts = GetAllBitmapFonts (hps, & pfm) ;
               WinReleasePS (hps) ;

                         // Get menu window handle

               hwndMenu = WinWindowFromID (WinQueryWindow (hwnd, QW_PARENT),
                                           FID_MENU) ;
               return 0 ;

          case WM_SIZE:
               cyClient = HIUSHORT (mp2) ;
               return 0 ;

          case WM_COMMAND:
               switch (COMMANDMSG(&msg)->cmd)
                    {
                    case IDM_ITALIC:      fItalic   = ! fItalic   ;  break ;
                    case IDM_UNDERSCORE:  fUnder    = ! fUnder    ;  break ;
                    case IDM_OUTLINE:     fOutline  = ! fOutline  ;  break ;
                    case IDM_STRIKEOUT:   fStrike   = ! fStrike   ;  break ;
                    case IDM_BOLD:        fBold     = ! fBold     ;  break ;
                    case IDM_BASELINE:    fBaseline = ! fBaseline ;  break ;
                    case IDM_TEXTBOX:     fTextBox  = ! fTextBox  ;  break ;

                    default:  return 0 ;
                    }

               WinCheckMenuItem (hwndMenu, COMMANDMSG(&msg)->cmd,
                    ! WinIsMenuItemChecked (hwndMenu, COMMANDMSG(&msg)->cmd)) ;

               WinInvalidateRect (hwnd, NULL, TRUE) ;
               return 0 ;

          case WM_PAINT:
               hps = WinBeginPaint (hwnd, NULLHANDLE, NULL) ;

               GpiErase (hps) ;

                    // Get new fonts if they've changed

               if (QFA_PUBLIC & GpiQueryFontAction (hps, QFA_PUBLIC))
                    {
                    free (pfm) ;
                    lFonts = GetAllBitmapFonts (hps, & pfm) ;
                    }

                    // Set POINTL structure to upper left corner of client

               ptl.x = 0 ;
               ptl.y = cyClient ;

                    // Loop through all the bitmap fonts

               for (l = 0 ; l < lFonts ; l++)
                    {
                         // Define the FATTRS structure

                    fat.usRecordLength  = sizeof (FATTRS) ;

                    fat.fsSelection = (fItalic  ? FATTR_SEL_ITALIC     : 0) |
                                      (fUnder   ? FATTR_SEL_UNDERSCORE : 0) |
                                      (fOutline ? FATTR_SEL_OUTLINE    : 0) |
                                      (fStrike  ? FATTR_SEL_STRIKEOUT  : 0) |
                                      (fBold    ? FATTR_SEL_BOLD       : 0) ;

                    fat.lMatch          = 0 ;

                    strcpy (fat.szFacename, pfm[l].szFacename) ;

                    fat.idRegistry      = pfm[l].idRegistry ;
                    fat.usCodePage      = pfm[l].usCodePage ;
                    fat.lMaxBaselineExt = pfm[l].lMaxBaselineExt ;
                    fat.lAveCharWidth   = pfm[l].lAveCharWidth ;
                    fat.fsType          = 0 ;
                    fat.fsFontUse       = 0 ;

                         // Create the logical font and select it

                    GpiCreateLogFont (hps, NULL, LCID_FONT, &fat) ;
                    GpiSetCharSet (hps, LCID_FONT) ;

                         // Query the font metrics of the current font

                    GpiQueryFontMetrics (hps, sizeof (FONTMETRICS), &fm) ;

                         // Set up a text string to display

                    sprintf (szBuffer, " \xDB %s - %d points \xDB ",
                             fm.szFacename, fm.sNominalPointSize / 10) ;

                         // Drop POINTL structure to baseline of font

                    ptl.y -= fm.lMaxAscender ;

                         // Display the character string

                    GpiCharStringAt (hps, &ptl, strlen (szBuffer), szBuffer) ;

                         // Adjust text box points for left baseline

                    GpiQueryTextBox (hps, strlen (szBuffer), szBuffer,
                                     TXTBOX_COUNT, aptl) ;

                    for (i = 0 ; i < TXTBOX_COUNT ; i++)
                         {
                         aptl[i].x += ptl.x ;
                         aptl[i].y += ptl.y ;
                         }

                         // Possibly display the baseline

                    if (fBaseline)
                         {
                         GpiMove (hps, &ptl) ;
                         GpiLine (hps, aptl + TXTBOX_CONCAT) ;
                         }

                         // Possibly display the character box

                    if (fTextBox)
                         {
                         GpiMove (hps, aptl + TXTBOX_TOPLEFT) ;
                         GpiLine (hps, aptl + TXTBOX_TOPRIGHT) ;
                         GpiLine (hps, aptl + TXTBOX_BOTTOMRIGHT) ;
                         GpiLine (hps, aptl + TXTBOX_BOTTOMLEFT) ;
                         GpiLine (hps, aptl + TXTBOX_TOPLEFT) ;
                         }

                         // Drop POINTL structure down to bottom of text

                    ptl.y -= fm.lMaxDescender ;

                         // Select the default font; delete the logical font

                    GpiSetCharSet (hps, LCID_DEFAULT) ;
                    GpiDeleteSetId (hps, LCID_FONT) ;
                    }

               WinEndPaint (hps) ;
               return 0 ;

          case WM_DESTROY:
               if (lFonts > 0)
                    free (pfm) ;

               return 0 ;
          }
     return WinDefWindowProc (hwnd, msg, mp1, mp2) ;
     }
