@ECHO OFF
IF '%2'=='' GOTO syntax
IF '%2'=='again' GOTO SecondRound
IF EXIST ERROR.LOG DEL ERROR.LOG
REM *** To cut "n" characters from a filename, copy it starting
REM *** at character number n+1
STRINGS start=ADD %2,1
REM *** Call CUTB again for each matching file
FOR %%f IN (%1) DO CALL %0 %%f again
REM *** Clear the environment variables we used
SET start=|SET nam=|SET nam2=|SET ext=
IF NOT EXIST ERROR.LOG GOTO done
REM *** Display the log of errors.
MORE < ERROR.LOG
GOTO done
:SecondRound
REM *** Here begins the code that gets executed for
REM *** each filename that matches the template. First,
REM *** split it into name and extension.
STRINGS nam=FILENAME %1
STRINGS ext=FILEEXT %1
REM *** Don't shorten our ERROR.LOG!
IF '%nam%.%ext%'=='ERROR.LOG' GOTO done
IF EXIST %nam%.%ext% GOTO IsHere
REM *** If the file isn't in the current directory,
REM *** report the error and quit.
ECHO File %nam%.%ext% not in current directory >> ERROR.LOG
GOTO done
:IsHere
SET nam2=
STRINGS nam2=MID %nam%,%start%,8
REM *** If the name is long enough, variable nam2 will
REM *** be non-null. Otherwise, report the error.
IF NOT '%nam2%'=='' GOTO OkLen
ECHO Cannot shorten %nam%.%ext% >> ERROR.LOG
GOTO done
:OkLen
REM *** If a file already exists with the newly shortened
REM *** name, report the error and skip it.
IF NOT EXIST %nam2%.%ext% GOTO OkName
ECHO Cannot rename %nam%.%ext% to %nam2%.%ext% >> ERROR.LOG
ECHO      because %nam2%.%ext% already exists. >> ERROR.LOG
GOTO done
:OkName
REM *** FINALLY! Perform the shorten-renaming.
REN %nam%.%ext% %nam2%.%ext%
GOTO done
:syntax
ECHO SYNTAX: "CUTB filespec n", where n is from 1 to 7
:done
