//
// HexView.H -- Header File for HexView.C
//

#if !defined(WIN32)

  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
  #define THUMBPOS  LOWORD(lParam)

#else

  #define WIN16     FALSE
  #define THUMBPOS  HIWORD(wParam)

#endif

struct decodeWord {                         // structure associates
    UINT Code;                              // messages or menu IDs
    LONG (*Fxn)(HWND, UINT, UINT, LONG); }; // with a function

#define     IDM_OPEN     100
#define     IDM_EXIT     101
#define     IDM_ABOUT    102

// Function prototypes
INT APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
BOOL InitApp(HANDLE);
BOOL InitInstance(HANDLE, INT);
BOOL TermInstance(HANDLE);
LONG FAR APIENTRY FrameWndProc(HWND, UINT, UINT, LONG);
LONG FAR APIENTRY ChildWndProc(HWND, UINT, UINT, LONG);
BOOL FAR APIENTRY AboutDlgProc (HWND, UINT, UINT, LONG);
LONG DoDestroy(HWND, UINT, UINT, LONG);
LONG DoClose(HWND, UINT, UINT, LONG);
LONG DoPaint(HWND, UINT, UINT, LONG);
LONG DoChildPaint(HWND, UINT, UINT, LONG);
LONG DoSize(HWND, UINT, UINT, LONG);
LONG DoCommand(HWND, UINT, UINT, LONG);
LONG DoVScroll(HWND, UINT, UINT, LONG);
LONG DoMenuOpen(HWND, UINT, UINT, LONG);
LONG DoMenuExit(HWND, UINT, UINT, LONG);
LONG DoMenuAbout(HWND, UINT, UINT, LONG);
VOID OpenDataFile(VOID);
VOID CloseDataFile(VOID);
VOID SetWindowCaption(char *);
VOID Repaint(VOID);
VOID SetFilePosition(LONG);
VOID ConfigDisplay(VOID);
VOID ThumbTrack(INT);
VOID DisplayLine(HDC hdc, INT line);
VOID UpdateFrameProfile(VOID);

