/* 
CMDCLIP.C -- put commands on Windows clipboard, for CLIPSERV

Copyright (c) 1992 Ziff Davis Communications
PC Magazine * Andrew Schulman (June 1992)
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "winclip.h"

/* Save away contents of clipboard before changing it */
static char *save = 0;

/* Before exiting, make sure we restore the saved clip contents */
void cleanup(char *s, int ret) 
{ 
	if (s)
		puts(s); 
	if (save)
	{
		PutClipString(save);	/* put it back on clipboard */
		FreeClipString(save);
	}
	exit(ret);
}

int Clipserv(void)
{
	char *s;
	int i;
	PutClipString("CMDCLIP INSTCHECK");
	for (i=0; i<5; i++)
	{
		Yield();
		s = GetClipString();
		if (strcmp(s, "CLIPREPLY INSTOK") == 0)
		{
			FreeClipString(s);
			return 1;
		}
		else
			FreeClipString(s);
	}
	/* still here */
	return 0;
}

int main(int argc, char *argv[])
{
    char buf[256], *s;
	char far *cmdtail;
	int len;
	int i;

    if (argc < 2)
        cleanup("usage: cmdclip <clipserv command> [args...]", 1);
	
	/* Make sure we're running under Windows */
    if (! WindowsClipboard())
        cleanup("This program requires Windows Enhanced mode", 1);
	
	/* Save away current contents of clipboard, except if
	   it's just an old CMDCLIP request */
	save = GetClipString();
	if (strncmp(save, "CMDCLIP ", 8) == 0)
	{
		FreeClipString(save);
		save = 0;
	}
	
	/* Make sure that CLIPSERV is running:  Clipserv() install check
	   works by putting a request into the clipboard and seeing if it
	   gets changed in the right away.  If it doesn't, CLIPSERV must
	   not be running.  But this test bashes the clipboard, so it
	   should only be done AFTER we've saved the clipboard's contents */
    if (! Clipserv())
        cleanup("This program requires Clipserv", 1);
    
	/* Assemble the command/request for CLIPSERV */
    strcpy(buf, "CMDCLIP ");
	cmdtail = MK_FP(_psp, 0x82);
	len = *((unsigned char far *) MK_FP(_psp, 0x80)) - 1;
	_fstrncat(buf, cmdtail, len);
    
	/* Send the request to CLIPSERV */
    PutClipString(buf);
	
	/* if asked server to exit, not going to be a reply! */
	if (strcmp(argv[1], "EXIT") != 0)
	{
		/* Wait for CLIPSERV for reply.  As long as the clipboard 
		   contents still match the request we put in there, we know 
		   that CLIPSERV hasn't responded yet. Yield() to give
		   CLIPSERV a chance. Because 2F/1680 Yield doesn't work so
		   good, especially in 3.1 Enhanced mode, Yield (in WINCLIP.C)
		   does a few INT 28h Idle calls instead */
		while (strcmp(buf, s = GetClipString()) == 0)
		{
			Yield();
			if (i++ > 10)
				cleanup("CLIPSERV went down", 1);
			FreeClipString(s);
		}

		/* Finally, the clipboard contents have been changed, hopefully
		   by CLIPSERV.  (We could check for the case of other programs
		   changing the clipboard at just the wrong moment, but this 
		   works fine in practice.)  So we display what is hopefully
		   CLIPSERV's reply. */
		puts(s);
		
		FreeClipString(s);
	}

	/* Free up memory, restore the old clipboard contents, and leave */
	cleanup(NULL, 0);
    return 0;
}

