/* 
GETCLIP.C -- DOS program gets text from Windows clipboard
requires WINCLIP.C
for example (Borland C++): bcc getclip.c winclip.c

Copyright (c) 1992 Ziff Davis Communications
PC Magazine * Andrew Schulman (June 1992)
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "winclip.h"

void fail(char *s) { fputs(s, stderr); fputs("\n", stderr); exit(1); }

int main(int argc, char *argv[])
{
    char *s;
    
    fputs("GETCLIP version 1.0\n", stderr);
    fputs("Copyright (c) 1992 Ziff Davis Communications "
          "* Andrew Schulman\n\n", stderr);
      
    if ((argc > 1) && (argv[1][0]=='/') && (argv[1][1]=='?')) // /?
		fail("GETCLIP retrieves text from the Windows clipboard");
    
    if (! WindowsClipboard())
		fail("This program must run in a DOS box "
             "under Enhanced mode Windows");

    if (s = GetClipString())
    {
        puts(s);
        FreeClipString(s);
    }
    else
        puts("* clipboard empty *");
    return 0;
}

