// BADAPP - Application Error Testbed for Windows 3.1
// Copyright (C) 1992 Ray Duncan
// Ziff Davis Publishing * PC Magazine

#define dim(x) (sizeof(x) / sizeof(x[0]))   // returns no. of elements

#include "windows.h"
#include "badapp.h"

HANDLE hInst;                               // module instance handle
HWND hFrame;                                // handle for frame window

char szShortAppName[] = "BadApp";          	// short application name
char szAppName[] = "BadApp - UAE Tester"; 	// long application name
char szMenuName[] = "BadAppMenu";          	// name of menu resource

struct decodeWord {                         // structure associates
    UINT Code;                              // messages or menu IDs
    LONG (*Fxn)(HWND, UINT, UINT, LONG); }; // with a function

//
// Table of window messages supported by FrameWndProc()
// and the functions which correspond to each message.
//
struct decodeWord messages[] = {
	WM_PAINT, DoPaint,
	WM_COMMAND, DoCommand,
	WM_DESTROY, DoDestroy, } ;

//
// Table of menubar item IDs and their corresponding functions.
//
struct decodeWord menuitems[] = {
	IDM_EXIT, DoMenuExit,
	IDM_GPFAULT, DoMenuGPFault,
    IDM_HANG, DoMenuHang,
	IDM_ZERODIV, DoMenuZeroDiv,
	IDM_BADHDC, DoMenuBadHDC,
	IDM_BADPTR, DoMenuBadPtr, } ;

//
// WinMain -- entry point for this application from Windows.
//
INT APIENTRY WinMain(HANDLE hInstance,
    HANDLE hPrevInstance, LPSTR lpCmdLine, INT nCmdShow)
{
    MSG msg;

    hInst = hInstance;                      // save this instance handle

    if(!hPrevInstance)                      // if first instance,
        if(!InitApplication(hInstance))     // register window class
            return(FALSE);                  // exit if couldn't register

    if(!InitInstance(hInstance, nCmdShow))  // create this instance's window
        return(FALSE);                      // exit if create failed

    while(GetMessage(&msg, NULL, 0, 0))     // while message != WM_QUIT
    {
        TranslateMessage(&msg);             // translate virtual key codes
        DispatchMessage(&msg);              // dispatch message to window
    }

    TermInstance(hInstance);                // clean up for this instance
    return(msg.wParam);                     // return code = WM_QUIT value
}

//
// InitApplication --- global initialization code for this application.
//
BOOL InitApplication(HANDLE hInstance)
{
    WNDCLASS  wc;

    // set parameters for frame window class
    wc.style = CS_HREDRAW|CS_VREDRAW;       // class style
    wc.lpfnWndProc = FrameWndProc;          // class callback function
    wc.cbClsExtra = 0;                      // extra per-class data
    wc.cbWndExtra = 0;                      // extra per-window data
    wc.hInstance = hInstance;               // handle of class owner
    wc.hIcon = LoadIcon(hInst, "BadAppIcon");		// skull icon
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);       // default cursor
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); // background color 
    wc.lpszMenuName =  szMenuName;          // name of menu resource
    wc.lpszClassName = szShortAppName;      // name of window class

    return(RegisterClass(&wc));             // register class, return status
}

//
// InitInstance --- instance initialization code for this application.
//
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
    hFrame = CreateWindow(                  // create frame window
        szShortAppName,                     // window class name
        szAppName,                          // text for title bar
        WS_OVERLAPPEDWINDOW,                // window style
        CW_USEDEFAULT, CW_USEDEFAULT,       // default position
        CW_USEDEFAULT, CW_USEDEFAULT,       // default size
        NULL,                               // no parent window
        NULL,                               // use class default menu
        hInstance,                          // window owner
        NULL);                              // unused pointer

    if(!hFrame) return(FALSE);              // error, can't create window

    ShowWindow(hFrame, nCmdShow);           // make frame window visible
    UpdateWindow(hFrame);                   // force WM_PAINT message
    return(TRUE);                           // return success flag
}

//
// TermInstance -- instance termination code for this application.
//
BOOL TermInstance(HANDLE hinstance)
{
    return(TRUE);                           // return success flag
}

//
// FrameWndProc --- callback function for application frame window.
//
LONG FAR APIENTRY FrameWndProc(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    int i;                                  // scratch variable

    for(i = 0; i < dim(messages); i++)      // decode window message and
    {                                       // run corresponding function
        if(wMsg == messages[i].Code)
            return((*messages[i].Fxn)(hWnd, wMsg, wParam, lParam));
    }

    return(DefWindowProc(hWnd, wMsg, wParam, lParam));
}

//
// DoCommand -- process WM_COMMAND message for frame window by
// decoding the menubar item with the menuitems[] array, then
// running the corresponding function to process the command.
// 
LONG DoCommand(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    int i;                                  // scratch variable

    for(i = 0; i < dim(menuitems); i++)     // decode menu command and
    {                                       // run corresponding function
        if(wParam == menuitems[i].Code)
            return((*menuitems[i].Fxn)(hWnd, wMsg, wParam, lParam));
    }

    return(DefWindowProc(hWnd, wMsg, wParam, lParam));
}

//
// DoDestroy -- process WM_DESTROY message for frame window.
// 
LONG DoDestroy(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    PostQuitMessage(0);                     // force WM_QUIT message to
    return(FALSE);                        	// terminate the event loop
}

//
// DoPaint -- process WM_PAINT message for frame window.  Select
// a pretty font, then display a message in the center of the window
// to show that the program is alive.
// 
LONG DoPaint(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rect;
	HFONT hfont;

	hdc = BeginPaint(hWnd, &ps);			// get device context
	GetClientRect(hWnd, &rect);				// get client area dimensions
	hfont = CreateFont(-36, 0, 0, 0, 700, TRUE, 0, 0, ANSI_CHARSET,
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY, (FF_MODERN << 4) + DEFAULT_PITCH,
		"Ariel");
	SelectObject(hdc, hfont);				// select new font
	DrawText(hdc, "I'm Really Bad!", -1, 	// paint text in window
		&rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);	
	EndPaint(hWnd, &ps);					// release device context
    return(FALSE);                              
}

//
// DoMenuExit -- process File-Exit command from menu bar.
// 
LONG DoMenuExit(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
    SendMessage (hWnd, WM_CLOSE, 0, 0L);    // send window close message    
    return(FALSE);                        	// to shut down the app
}

//
// DoMenuGPFault -- process GP Fault command from menu bar.  Force
// a fault by dereferencing a null pointer.
// 
LONG DoMenuGPFault(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	char c;
	char far *p = NULL;

	c = *p;									// dereference bogus pointer
    return(FALSE);                        	// to force a GP fault
}

//
// DoMenuHang -- process Infinite Loop command from menu bar.  
// Execute an infinite loop until the user forces a local reboot
// with Ctl-Alt-Del.
// 
LONG DoMenuHang(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	while(TRUE)
	{
		// execute practically forever 
	}

	return(FALSE);
}

//
// DoMenuZeroDiv -- process Divide by Zero command from menu bar.
// Declare some integers, then force a divide by zero fault.
// 
LONG DoMenuZeroDiv(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	int i, j, k = 0;

	i = j / k;
	return(FALSE);
}

//
// DoMenuBadHDC -- process Bad HDC command from menu bar.  Call the
// DrawText() API function with a bogus HDC.
// 
LONG DoMenuBadHDC(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	HDC hdc = 0;
	RECT rect;

	GetClientRect(hWnd, &rect);				// get client area dimensions
	DrawText(hdc, "Bogus HDC!", -1, 		// use invalid HDC to paint text
		&rect, DT_CENTER | DT_VCENTER | DT_SINGLELINE);	
    return(FALSE);                              
}

//
// DoMenuBadPtr -- process Bad Pointer command from menu bar.  Call the
// MessageBox() API function with a NULL pointer to the message string.
// 
LONG DoMenuBadPtr(HWND hWnd, UINT wMsg, UINT wParam, LONG lParam)
{
	MessageBox(hWnd, NULL, NULL, MB_OK | MB_ICONSTOP);
    return(FALSE);                        	
}

