
/*
*	All output pointers to char arrays that are to be "filled in"
*	must have their memory allocated per the #defines herein.
*/

#define exist(sz)	(!access(sz, 00))	/* #include <io.h> */

				/* input			output	     */
#define FILESPEC	64	/* "d:\\path\\filename.ext"     same         */
#define FILESPEC_DRIVE	3	/* "d:", "d" or ""              "d:" or ""   */
#define FILESPEC_PATH	63	/* "\\path\\", ..., "\\" or ""  same         */
#define FILESPEC_NAME	9	/* "filename"                   same         */
#define FILESPEC_EXT	5	/* ".ext", "ext" or ""          ".ext" or "" */

struct	CHKDSK {	/* Do NOT change the order of structure elements! */
	unsigned int	uiSectorsPerCluster;	/* A */
	unsigned int	uiAvailableClusters;	/* B */
	unsigned int	uiBytesPerSector;	/* C */
	unsigned int	uiTotalClusters;	/* D */
	long		lTotalDiskSpace;	/* C * A * D */
	long		lAvailableOnDisk;	/* C * A * B */
	unsigned int	uiBytesPerCluster;	/* C * A */
	unsigned int	uiPercentFreeSpace;	/* (B * 100) / D and rounded */
	};

extern	char		*MakeFilespec(char *, char *, char *, char *, char *);
extern	void		ParseFilespec(char *, char *, char *, char *, char *);

extern	void		chdrv(char *);
extern	struct CHKDSK	chkdsk(char *);
extern	void		verify(int);
extern	int		IsPrnOn(void);	/* M model only */

