
// INI 1.0
// Copyright (c) 1986-87 Fran Finnegan Associates
// Copyright (c) 1988-92 Finnegan O'Malley & Company Inc.
// All Rights Reserved.
// First Published in PC Magazine, June 30, 1992.

// originally developed under Microsoft C 4.0
// updated for Microsoft C 5.1

#include <stdio.h>
#include <string.h>

#include "config.i"
#include "const.i"
#include "string.i"

#include "charasci.c"
#include "config.c"
#include "filespec.c"
#include "strtrunc.c"

extern	int		main(int argc, char **argv);

static	char		Copyright[] =
		"%s 1.0\n"
		"Copyright (c) 1988-92 Finnegan O'Malley & Company Inc.  "
		"All Rights Reserved.\n"
		"First Published in PC Magazine, June 30, 1992.\n";

/////////////////////////////////////////////////////////////////

extern	int		main
(
	int		argc,
	char		**argv
)
{
static	char		szNUL[] = "NUL";

if (argc != 5 || *argv[1] == '-' || *argv[1] == '/' || *argv[1] == '?')
    {
    fprintf(stderr, Copyright, argv[0]);
    fprintf(stderr, "\nUsage:\t%s filespec \"section\" \"key\" \"string\"\n"
	    "where:\t\"section\", \"key\" and/or \"string\" may be \"nul\"\n"
	    "\tand must be enclosed in double-quotes if they contain blanks\a\n",
	    argv[0]);
    return 1;
    }

gbConfigCloseFileOnExit = YES;
gbConfigDeleteBakOnExit = NO;

if (!WriteConfigString(argv[1], 				// File
	  (!IsStrEquiv(argv[2], szNUL)?  argv[2]:  NULL),	// Section
	  (!IsStrEquiv(argv[3], szNUL)?  argv[3]:  NULL),	// Key
	  (!IsStrEquiv(argv[4], szNUL)?  argv[4]:  NULL)))	// String
    {
    fprintf(stderr, Copyright, argv[0]);
    fprintf(stderr, "\nError updating %s\a\n", argv[1]);
    return 2;
    }
return 0;
}

